/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.QueryLifecycle;
import org.apache.druid.server.QueryResource;
import org.apache.druid.server.QueryResponse;
import org.apache.druid.server.QueryResultPusher;
import org.apache.druid.server.ResourceIOReaderWriterFactory;
import org.apache.druid.server.ResponseContextConfig;

public class QueryResourceQueryResultPusherFactory {
    protected final ObjectMapper jsonMapper;
    private final ResponseContextConfig responseContextConfig;
    private final DruidNode selfNode;

    @Inject
    public QueryResourceQueryResultPusherFactory(@Json ObjectMapper jsonMapper, ResponseContextConfig responseContextConfig, @Self DruidNode selfNode) {
        this.jsonMapper = jsonMapper;
        this.responseContextConfig = responseContextConfig;
        this.selfNode = selfNode;
    }

    public QueryResourceQueryResultPusher factorize(QueryResource.QueryMetricCounter counter, HttpServletRequest req, QueryLifecycle queryLifecycle, ResourceIOReaderWriterFactory.ResourceIOReaderWriter io) {
        return new QueryResourceQueryResultPusher(this.jsonMapper, this.responseContextConfig, this.selfNode, counter, req, queryLifecycle, io);
    }

    private static String getPreviousEtag(HttpServletRequest req) {
        return req.getHeader("If-None-Match");
    }

    public static class QueryResourceQueryResultPusher
    extends QueryResultPusher {
        private final HttpServletRequest req;
        private final QueryLifecycle queryLifecycle;
        private final ResourceIOReaderWriterFactory.ResourceIOReaderWriter io;
        private final QueryResource.QueryMetricCounter counter;

        public QueryResourceQueryResultPusher(ObjectMapper jsonMapper, ResponseContextConfig responseContextConfig, DruidNode selfNode, QueryResource.QueryMetricCounter counter, HttpServletRequest req, QueryLifecycle queryLifecycle, ResourceIOReaderWriterFactory.ResourceIOReaderWriter io) {
            super(req, jsonMapper, responseContextConfig, selfNode, counter, queryLifecycle.getQueryId(), MediaType.valueOf((String)io.getResponseWriter().getResponseType()), (Map<String, String>)ImmutableMap.of(), queryLifecycle.getQuery().getContext());
            this.req = req;
            this.queryLifecycle = queryLifecycle;
            this.io = io;
            this.counter = counter;
        }

        @Override
        public QueryResultPusher.ResultsWriter start() {
            return new QueryResultPusher.ResultsWriter(){
                private QueryResponse<Object> queryResponse;

                @Override
                public Response.ResponseBuilder start() {
                    this.queryResponse = queryLifecycle.execute();
                    ResponseContext responseContext = this.queryResponse.getResponseContext();
                    String prevEtag = QueryResourceQueryResultPusherFactory.getPreviousEtag(req);
                    if (prevEtag != null && prevEtag.equals(responseContext.getEntityTag())) {
                        queryLifecycle.emitLogsAndMetrics(null, req.getRemoteAddr(), -1L);
                        counter.incrementSuccess();
                        return Response.status((Response.Status)Response.Status.NOT_MODIFIED);
                    }
                    return null;
                }

                @Override
                public QueryResponse<Object> getQueryResponse() {
                    return this.queryResponse;
                }

                @Override
                public QueryResultPusher.Writer makeWriter(OutputStream out) throws IOException {
                    return new QueryResource.NativeQueryWriter(queryLifecycle.newOutputWriter(io), out);
                }

                @Override
                public void recordSuccess(long numBytes) {
                    queryLifecycle.emitLogsAndMetrics(null, req.getRemoteAddr(), numBytes);
                }

                @Override
                public void recordFailure(Exception e, long bytesWritten) {
                    queryLifecycle.emitLogsAndMetrics(e, req.getRemoteAddr(), bytesWritten);
                }

                @Override
                public void close() {
                }
            };
        }

        @Override
        public void writeException(Exception e, OutputStream out) throws IOException {
            ObjectMapper objectMapper = this.queryLifecycle.newOutputWriter(this.io);
            out.write(objectMapper.writeValueAsBytes((Object)e));
        }
    }
}

