/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.rpc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.net.URI;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.Either;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.java.util.http.client.Request;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.java.util.http.client.response.ObjectOrErrorResponseHandler;
import org.apache.druid.java.util.http.client.response.StringFullResponseHolder;
import org.apache.druid.rpc.HttpResponseException;
import org.apache.druid.rpc.RequestBuilder;
import org.apache.druid.rpc.RpcException;
import org.apache.druid.rpc.ServiceClient;
import org.apache.druid.rpc.ServiceClosedException;
import org.apache.druid.rpc.ServiceLocation;
import org.apache.druid.rpc.ServiceLocations;
import org.apache.druid.rpc.ServiceLocator;
import org.apache.druid.rpc.ServiceNotAvailableException;
import org.apache.druid.rpc.ServiceRetryPolicy;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;

public class ServiceClientImpl
implements ServiceClient {
    private static final Logger log = new Logger(ServiceClientImpl.class);
    private final String serviceName;
    private final HttpClient httpClient;
    private final ServiceLocator serviceLocator;
    private final ServiceRetryPolicy retryPolicy;
    private final ScheduledExecutorService connectExec;
    private final AtomicReference<ServiceLocation> preferredLocationNoPath = new AtomicReference();

    public ServiceClientImpl(String serviceName, HttpClient httpClient, ServiceLocator serviceLocator, ServiceRetryPolicy retryPolicy, ScheduledExecutorService connectExec) {
        this.serviceName = (String)Preconditions.checkNotNull((Object)serviceName, (Object)"serviceName");
        this.httpClient = (HttpClient)Preconditions.checkNotNull((Object)httpClient, (Object)"httpClient");
        this.serviceLocator = (ServiceLocator)Preconditions.checkNotNull((Object)serviceLocator, (Object)"serviceLocator");
        this.retryPolicy = (ServiceRetryPolicy)Preconditions.checkNotNull((Object)retryPolicy, (Object)"retryPolicy");
        this.connectExec = (ScheduledExecutorService)Preconditions.checkNotNull((Object)connectExec, (Object)"connectExec");
        if (retryPolicy.maxAttempts() == 0L) {
            throw new IAE("Invalid maxAttempts[%d] in retry policy", new Object[]{retryPolicy.maxAttempts()});
        }
    }

    @Override
    public <IntermediateType, FinalType> ListenableFuture<FinalType> asyncRequest(RequestBuilder requestBuilder, HttpResponseHandler<IntermediateType, FinalType> handler) {
        SettableFuture retVal = SettableFuture.create();
        this.tryRequest(requestBuilder, handler, retVal, 0L, (ImmutableSet<String>)ImmutableSet.of());
        return retVal;
    }

    @Override
    public ServiceClientImpl withRetryPolicy(ServiceRetryPolicy newRetryPolicy) {
        return new ServiceClientImpl(this.serviceName, this.httpClient, this.serviceLocator, newRetryPolicy, this.connectExec);
    }

    private <IntermediateType, FinalType> void tryRequest(final RequestBuilder requestBuilder, final HttpResponseHandler<IntermediateType, FinalType> handler, final SettableFuture<FinalType> retVal, final long attemptNumber, ImmutableSet<String> redirectLocations) {
        this.whenServiceReady(serviceLocations -> {
            ListenableFuture responseFuture;
            if (retVal.isCancelled()) {
                return;
            }
            ServiceLocation serviceLocation = this.pick((ServiceLocations)serviceLocations);
            final long nextAttemptNumber = attemptNumber + 1L;
            if (serviceLocation == null) {
                if (this.retryPolicy.retryNotAvailable() && this.shouldTry(nextAttemptNumber)) {
                    long backoffMs = ServiceClientImpl.computeBackoffMs(this.retryPolicy, attemptNumber);
                    log.info("Service [%s] not available on attempt #%d; retrying in %,d ms.", new Object[]{this.serviceName, nextAttemptNumber, backoffMs});
                    this.connectExec.schedule(() -> this.tryRequest(requestBuilder, handler, retVal, nextAttemptNumber, (ImmutableSet<String>)ImmutableSet.of()), backoffMs, TimeUnit.MILLISECONDS);
                } else {
                    retVal.setException((Throwable)new ServiceNotAvailableException(this.serviceName));
                }
                return;
            }
            final Request request = requestBuilder.build(serviceLocation);
            log.debug("Service [%s] request [%s %s] starting.", new Object[]{this.serviceName, request.getMethod(), request.getUrl()});
            ListenableFuture theResponseFuture = responseFuture = this.httpClient.go(request, (HttpResponseHandler)new ObjectOrErrorResponseHandler(handler), requestBuilder.getTimeout());
            retVal.addListener(() -> {
                if (retVal.isCancelled()) {
                    theResponseFuture.cancel(true);
                }
            }, (Executor)Execs.directExecutor());
            Futures.addCallback((ListenableFuture)responseFuture, (FutureCallback)new FutureCallback<Either<StringFullResponseHolder, FinalType>>((ServiceLocations)serviceLocations, (ImmutableSet)redirectLocations){
                final /* synthetic */ ServiceLocations val$serviceLocations;
                final /* synthetic */ ImmutableSet val$redirectLocations;
                {
                    this.val$serviceLocations = serviceLocations;
                    this.val$redirectLocations = immutableSet;
                }

                public void onSuccess(@Nullable Either<StringFullResponseHolder, FinalType> result) {
                    try {
                        if (result != null && result.isValue()) {
                            this.handleResultValue(result.valueOrThrow());
                        } else {
                            StringFullResponseHolder errorHolder;
                            StringFullResponseHolder stringFullResponseHolder = errorHolder = result != null ? (StringFullResponseHolder)result.error() : null;
                            if (errorHolder != null && ServiceClientImpl.isRedirect(errorHolder.getResponse().getStatus())) {
                                this.handleRedirect(errorHolder);
                            } else if (ServiceClientImpl.this.shouldTry(nextAttemptNumber) && (errorHolder == null || ServiceClientImpl.this.retryPolicy.retryHttpResponse(errorHolder.getResponse()))) {
                                this.handleRetryableErrorResponse(errorHolder);
                            } else if (errorHolder != null) {
                                retVal.setException((Throwable)new HttpResponseException(errorHolder));
                            } else {
                                retVal.setException((Throwable)new RpcException(ServiceClientImpl.this.buildErrorMessage(request, null, -1L, nextAttemptNumber), new Object[0]));
                            }
                        }
                    }
                    catch (Throwable t) {
                        log.error(t, "Service[%s] handler exited unexpected", new Object[]{ServiceClientImpl.this.serviceName});
                        retVal.setException((Throwable)new RpcException(t, "Service [%s] handler exited unexpectedly", ServiceClientImpl.this.serviceName));
                    }
                }

                public void onFailure(Throwable t) {
                    try {
                        long nextAttemptNumber2 = attemptNumber + 1L;
                        if (ServiceClientImpl.this.shouldTry(nextAttemptNumber2) && ServiceClientImpl.this.retryPolicy.retryThrowable(t)) {
                            long backoffMs = ServiceClientImpl.computeBackoffMs(ServiceClientImpl.this.retryPolicy, attemptNumber);
                            if (ServiceClientImpl.this.retryPolicy.retryLoggable()) {
                                log.noStackTrace().info(t, ServiceClientImpl.this.buildErrorMessage(request, null, backoffMs, nextAttemptNumber2), new Object[0]);
                            } else if (log.isDebugEnabled()) {
                                log.noStackTrace().debug(t, ServiceClientImpl.this.buildErrorMessage(request, null, backoffMs, nextAttemptNumber2), new Object[0]);
                            } else if (nextAttemptNumber2 > 0L && nextAttemptNumber2 % 10L == 0L) {
                                log.noStackTrace().info(t, ServiceClientImpl.this.buildErrorMessage(request, null, backoffMs, nextAttemptNumber2), new Object[0]);
                            }
                            ServiceClientImpl.this.connectExec.schedule(() -> ServiceClientImpl.this.tryRequest(requestBuilder, handler, retVal, nextAttemptNumber2, (ImmutableSet<String>)ImmutableSet.of()), backoffMs, TimeUnit.MILLISECONDS);
                        } else {
                            retVal.setException((Throwable)new RpcException(t, ServiceClientImpl.this.buildErrorMessage(request, null, -1L, nextAttemptNumber2), new Object[0]));
                        }
                    }
                    catch (Throwable t2) {
                        retVal.setException((Throwable)new RpcException(t, "Service [%s] handler exited unexpectedly", ServiceClientImpl.this.serviceName));
                    }
                }

                private void handleResultValue(FinalType value) {
                    if (nextAttemptNumber > 1L) {
                        log.info("Service [%s] request [%s %s] completed.", new Object[]{ServiceClientImpl.this.serviceName, request.getMethod(), request.getUrl()});
                    } else {
                        log.debug("Service [%s] request [%s %s] completed.", new Object[]{ServiceClientImpl.this.serviceName, request.getMethod(), request.getUrl()});
                    }
                    retVal.set(value);
                }

                private void handleRetryableErrorResponse(StringFullResponseHolder errorHolder) {
                    long backoffMs = ServiceClientImpl.computeBackoffMs(ServiceClientImpl.this.retryPolicy, attemptNumber);
                    if (ServiceClientImpl.this.retryPolicy.retryLoggable()) {
                        log.noStackTrace().info(ServiceClientImpl.this.buildErrorMessage(request, errorHolder, backoffMs, nextAttemptNumber), new Object[0]);
                    } else if (log.isDebugEnabled()) {
                        log.noStackTrace().debug(ServiceClientImpl.this.buildErrorMessage(request, errorHolder, backoffMs, nextAttemptNumber), new Object[0]);
                    } else if (nextAttemptNumber > 0L && nextAttemptNumber % 10L == 0L) {
                        log.noStackTrace().info(ServiceClientImpl.this.buildErrorMessage(request, errorHolder, backoffMs, nextAttemptNumber), new Object[0]);
                    }
                    ServiceClientImpl.this.connectExec.schedule(() -> ServiceClientImpl.this.tryRequest(requestBuilder, handler, retVal, nextAttemptNumber, (ImmutableSet<String>)ImmutableSet.of()), backoffMs, TimeUnit.MILLISECONDS);
                }

                private void handleRedirect(StringFullResponseHolder errorHolder) {
                    String newUri = errorHolder.getResponse().headers().get("Location");
                    ServiceLocation redirectLocationNoPath = ServiceClientImpl.serviceLocationNoPathFromUri(newUri);
                    if (redirectLocationNoPath == null) {
                        retVal.setException((Throwable)new RpcException("Service [%s] redirected to invalid URL [%s]", ServiceClientImpl.this.serviceName, newUri));
                    } else if (this.val$serviceLocations.getLocations().stream().anyMatch(loc -> ServiceClientImpl.serviceLocationMatches(loc, redirectLocationNoPath))) {
                        boolean isRedirectChainTooLong;
                        boolean isRedirectLoop = this.val$redirectLocations.contains((Object)newUri);
                        boolean bl = isRedirectChainTooLong = (long)this.val$redirectLocations.size() >= 3L;
                        if (isRedirectLoop || isRedirectChainTooLong) {
                            if (ServiceClientImpl.this.retryPolicy.retryNotAvailable() && ServiceClientImpl.this.shouldTry(nextAttemptNumber)) {
                                long backoffMs = ServiceClientImpl.computeBackoffMs(ServiceClientImpl.this.retryPolicy, attemptNumber);
                                log.info("Service [%s] issued too many redirects on attempt #%d; retrying in %,d ms.", new Object[]{ServiceClientImpl.this.serviceName, nextAttemptNumber, backoffMs});
                                ServiceClientImpl.this.connectExec.schedule(() -> ServiceClientImpl.this.tryRequest(requestBuilder, handler, retVal, nextAttemptNumber, (ImmutableSet<String>)ImmutableSet.of()), backoffMs, TimeUnit.MILLISECONDS);
                            } else {
                                retVal.setException((Throwable)new ServiceNotAvailableException(ServiceClientImpl.this.serviceName, "issued too many redirects", new Object[0]));
                            }
                        } else {
                            ServiceClientImpl.this.preferredLocationNoPath.set(redirectLocationNoPath);
                            ImmutableSet newRedirectLocations = ImmutableSet.builder().addAll((Iterable)this.val$redirectLocations).add((Object)newUri).build();
                            ServiceClientImpl.this.connectExec.submit(() -> ServiceClientImpl.this.tryRequest(requestBuilder, handler, retVal, attemptNumber, (ImmutableSet<String>)newRedirectLocations));
                        }
                    } else if (ServiceClientImpl.this.retryPolicy.retryNotAvailable() && ServiceClientImpl.this.shouldTry(nextAttemptNumber)) {
                        long backoffMs = ServiceClientImpl.computeBackoffMs(ServiceClientImpl.this.retryPolicy, attemptNumber);
                        log.info("Service [%s] issued redirect to unknown URL [%s] on attempt #%d; retrying in %,d ms.", new Object[]{ServiceClientImpl.this.serviceName, newUri, nextAttemptNumber, backoffMs});
                        ServiceClientImpl.this.connectExec.schedule(() -> ServiceClientImpl.this.tryRequest(requestBuilder, handler, retVal, nextAttemptNumber, (ImmutableSet<String>)ImmutableSet.of()), backoffMs, TimeUnit.MILLISECONDS);
                    } else {
                        retVal.setException((Throwable)new ServiceNotAvailableException(ServiceClientImpl.this.serviceName, "issued redirect to unknown URL [%s]", newUri));
                    }
                }
            }, (Executor)this.connectExec);
        }, retVal);
    }

    private <T> void whenServiceReady(final Consumer<ServiceLocations> callback, final SettableFuture<T> retVal) {
        Futures.addCallback(this.serviceLocator.locate(), (FutureCallback)new FutureCallback<ServiceLocations>(){

            public void onSuccess(ServiceLocations locations) {
                if (locations.isClosed()) {
                    retVal.setException((Throwable)new ServiceClosedException(ServiceClientImpl.this.serviceName));
                    return;
                }
                try {
                    callback.accept(locations);
                }
                catch (Throwable t) {
                    retVal.setException((Throwable)new RpcException(t, "Service [%s] handler exited unexpectedly", ServiceClientImpl.this.serviceName));
                }
            }

            public void onFailure(Throwable t) {
                retVal.setException((Throwable)new RpcException(t, "Service [%s] locator encountered exception", ServiceClientImpl.this.serviceName));
            }
        }, (Executor)this.connectExec);
    }

    @Nullable
    private ServiceLocation pick(ServiceLocations locations) {
        ServiceLocation preferred = this.preferredLocationNoPath.get();
        if (preferred != null) {
            for (ServiceLocation location : locations.getLocations()) {
                if (!ServiceClientImpl.serviceLocationMatches(location, preferred)) continue;
                return location;
            }
        }
        return (ServiceLocation)Iterables.getFirst(locations.getLocations(), null);
    }

    private boolean shouldTry(long nextAttemptNumber) {
        return this.retryPolicy.maxAttempts() < 0L || nextAttemptNumber < this.retryPolicy.maxAttempts();
    }

    private String buildErrorMessage(Request request, @Nullable StringFullResponseHolder errorHolder, long backoffMs, long numAttempts) {
        StringBuilder errorMessage = new StringBuilder();
        errorMessage.append("Service [").append(this.serviceName).append("] request [").append(request.getMethod()).append(" ").append(request.getUrl()).append("]");
        if (errorHolder != null) {
            HttpResponseStatus httpResponseStatus = errorHolder.getStatus();
            errorMessage.append(" encountered server error [").append(httpResponseStatus).append("]");
        } else {
            errorMessage.append(" encountered exception");
        }
        errorMessage.append(" on attempt #").append(numAttempts);
        if (backoffMs > 0L) {
            errorMessage.append("; retrying in ").append(StringUtils.format((String)"%,d", (Object[])new Object[]{backoffMs})).append(" ms");
        }
        if (errorHolder != null) {
            errorMessage.append("; ").append(HttpResponseException.choppedBodyErrorMessage(errorHolder.getContent()));
        }
        return errorMessage.toString();
    }

    @VisibleForTesting
    public static long computeBackoffMs(ServiceRetryPolicy retryPolicy, long attemptNumber) {
        return Math.max(retryPolicy.minWaitMillis(), Math.min(retryPolicy.maxWaitMillis(), (long)(Math.pow(2.0, attemptNumber) * (double)retryPolicy.minWaitMillis())));
    }

    @Nullable
    @VisibleForTesting
    static ServiceLocation serviceLocationNoPathFromUri(@Nullable String uriString) {
        if (uriString == null) {
            return null;
        }
        try {
            ServiceLocation location = ServiceLocation.fromUri(URI.create(uriString));
            return new ServiceLocation(location.getHost(), location.getPlaintextPort(), location.getTlsPort(), "");
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    static boolean serviceLocationMatches(ServiceLocation left, ServiceLocation right) {
        return left.getHost().equals(right.getHost()) && ServiceClientImpl.portMatches(left.getPlaintextPort(), right.getPlaintextPort()) && ServiceClientImpl.portMatches(left.getTlsPort(), right.getTlsPort());
    }

    static boolean portMatches(int left, int right) {
        return left < 0 || right < 0 || left == right;
    }

    @VisibleForTesting
    static boolean isRedirect(HttpResponseStatus responseStatus) {
        int code = responseStatus.getCode();
        return code == HttpResponseStatus.TEMPORARY_REDIRECT.getCode() || code == HttpResponseStatus.FOUND.getCode() || code == HttpResponseStatus.MOVED_PERMANENTLY.getCode();
    }
}

