/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.security;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.ForbiddenException;

public class SecuritySanityCheckFilter
implements Filter {
    private static final Logger log = new Logger(SecuritySanityCheckFilter.class);
    private final String unauthorizedMessage;

    public SecuritySanityCheckFilter(ObjectMapper jsonMapper) {
        try {
            ForbiddenException forbiddenException = new ForbiddenException();
            forbiddenException.setStackTrace(new StackTraceElement[0]);
            this.unauthorizedMessage = jsonMapper.writeValueAsString((Object)forbiddenException);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        ServletOutputStream out = httpResponse.getOutputStream();
        Boolean authInfoChecked = (Boolean)request.getAttribute("Druid-Authorization-Checked");
        Boolean allowUnsecured = (Boolean)request.getAttribute("Druid-Allow-Unsecured-Path");
        AuthenticationResult result = (AuthenticationResult)request.getAttribute("Druid-Authentication-Result");
        if (authInfoChecked != null || result != null || allowUnsecured != null) {
            SecuritySanityCheckFilter.sendJsonError(httpResponse, 403, this.unauthorizedMessage, (OutputStream)out);
            out.close();
            return;
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    public static void sendJsonError(HttpServletResponse resp, int error, String errorJson, OutputStream outputStream) {
        resp.setStatus(error);
        resp.setContentType("application/json");
        resp.setCharacterEncoding("UTF-8");
        try {
            outputStream.write(errorJson.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException ioe) {
            log.error("Can't get writer from HTTP response.", new Object[0]);
        }
    }
}

