/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.model;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Strings;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.catalog.model.ColumnSpec;
import org.apache.druid.catalog.model.ModelProperties;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.granularity.GranularityType;
import org.apache.druid.java.util.common.granularity.PeriodGranularity;
import org.joda.time.Period;

public class CatalogUtils {
    public static List<String> columnNames(List<ColumnSpec> columns) {
        return columns.stream().map(col -> col.name()).collect(Collectors.toList());
    }

    public static Granularity asDruidGranularity(@Nonnull String value) {
        Granularity granularity;
        if (value.equalsIgnoreCase("ALL")) {
            return Granularities.ALL;
        }
        try {
            granularity = Granularity.fromString((String)value);
        }
        catch (IllegalArgumentException e) {
            try {
                granularity = new PeriodGranularity(new Period((Object)value), null, null);
            }
            catch (IllegalArgumentException e2) {
                throw new IAE("[%s] is an invalid granularity string.", new Object[]{value});
            }
        }
        return granularity;
    }

    public static List<String> stringToList(String value) {
        if (value == null) {
            return null;
        }
        return Arrays.asList(value.split(",\\s*"));
    }

    public static <T> T safeCast(Object value, Class<T> type, String key) {
        if (value == null) {
            return null;
        }
        try {
            return type.cast(value);
        }
        catch (ClassCastException e) {
            throw new IAE("Value [%s] is not valid for property [%s], expected type [%s]", new Object[]{value, key, type.getSimpleName()});
        }
    }

    public static <T> T safeGet(Map<String, Object> map, String key, Class<T> type) {
        return CatalogUtils.safeCast(map.get(key), type, key);
    }

    public static long getLong(Map<String, Object> map, String key) {
        Object value = map.get(key);
        if (value == null) {
            return 0L;
        }
        if (value instanceof Integer) {
            return ((Integer)value).intValue();
        }
        return CatalogUtils.safeCast(value, Long.class, key);
    }

    public static String getString(Map<String, Object> map, String key) {
        return CatalogUtils.safeGet(map, key, String.class);
    }

    public static List<String> getStringList(Map<String, Object> map, String key) {
        return CatalogUtils.stringToList(CatalogUtils.getString(map, key));
    }

    public static List<String> getStringArray(Map<String, Object> map, String key) {
        Object value = map.get(key);
        if (value == null) {
            return null;
        }
        return CatalogUtils.safeCast(value, List.class, key);
    }

    public static String stringListToLines(List<String> lines) {
        if (lines.isEmpty()) {
            return "";
        }
        return String.join((CharSequence)"\n", lines) + "\n";
    }

    public static String toString(Object obj) {
        try {
            return DefaultObjectMapper.INSTANCE.writerWithDefaultPrettyPrinter().writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new ISE("Failed to serialize TableDefn", new Object[0]);
        }
    }

    public static <T> List<T> concatLists(@Nullable List<T> base, @Nullable List<T> additions) {
        return Stream.of(base, additions).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public static String getNonBlankString(Map<String, Object> args, String parameter) {
        String value = CatalogUtils.getString(args, parameter);
        if (value != null && (value = value.trim()).isEmpty()) {
            throw new IAE("%s parameter cannot be a blank string", new Object[]{parameter});
        }
        return value;
    }

    public static List<String> getUriListArg(Map<String, Object> args, String parameter) {
        String urisString = CatalogUtils.getString(args, parameter);
        if (Strings.isNullOrEmpty((String)urisString)) {
            throw new IAE("One or more values are required for parameter %s", new Object[]{parameter});
        }
        return CatalogUtils.stringToList(urisString);
    }

    public static List<URI> stringToUriList(String uris) {
        return CatalogUtils.stringListToUriList(CatalogUtils.stringToList(uris));
    }

    public static List<URI> stringListToUriList(List<String> list) {
        if (list == null) {
            return null;
        }
        ArrayList<URI> uris = new ArrayList<URI>();
        for (String strValue : list) {
            try {
                uris.add(new URI(strValue));
            }
            catch (URISyntaxException e) {
                throw new IAE(StringUtils.format((String)"Argument [%s] is not a valid URI", (Object[])new Object[]{strValue}), new Object[0]);
            }
        }
        return uris;
    }

    public static Map<String, Object> mergeProperties(Map<String, ModelProperties.PropertyDefn<?>> properties, Map<String, Object> source, Map<String, Object> update) {
        if (update == null) {
            return source;
        }
        if (source == null) {
            return update;
        }
        HashMap<String, Object> merged = new HashMap<String, Object>(source);
        for (Map.Entry<String, Object> entry : update.entrySet()) {
            if (entry.getValue() == null) {
                merged.remove(entry.getKey());
                continue;
            }
            Object value = entry.getValue();
            ModelProperties.PropertyDefn<?> propDefn = properties.get(entry.getKey());
            if (propDefn != null) {
                value = propDefn.merge(merged.get(entry.getKey()), entry.getValue());
            }
            merged.put(entry.getKey(), value);
        }
        return merged;
    }

    public static void validateGranularity(String value) {
        if (value == null) {
            return;
        }
        Granularity granularity = CatalogUtils.asDruidGranularity(value);
        if (!GranularityType.isStandard((Granularity)granularity)) {
            throw new IAE("Unsupported segment graularity. Please use an equivalent of these granularities: %s.", new Object[]{Arrays.stream(GranularityType.values()).filter(granularityType -> !granularityType.equals((Object)GranularityType.NONE)).map(Enum::name).map(StringUtils::toLowerCase).collect(Collectors.joining(", "))});
        }
    }

    public static int findColumn(List<ColumnSpec> columns, String colName) {
        for (int i = 0; i < columns.size(); ++i) {
            if (!columns.get(i).name().equals(colName)) continue;
            return i;
        }
        return -1;
    }
}

