/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime.appenderator;

import javax.annotation.Nullable;
import org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;

public class AppenderatorDriverAddResult {
    private final SegmentIdWithShardSpec segmentIdentifier;
    private final int numRowsInSegment;
    private final long totalNumRowsInAppenderator;
    private final boolean isPersistRequired;

    public static AppenderatorDriverAddResult ok(SegmentIdWithShardSpec segmentIdentifier, int numRowsInSegment, long totalNumRowsInAppenderator, boolean isPersistRequired) {
        return new AppenderatorDriverAddResult(segmentIdentifier, numRowsInSegment, totalNumRowsInAppenderator, isPersistRequired);
    }

    public static AppenderatorDriverAddResult fail() {
        return new AppenderatorDriverAddResult(null, 0, 0L, false);
    }

    private AppenderatorDriverAddResult(@Nullable SegmentIdWithShardSpec segmentIdentifier, int numRowsInSegment, long totalNumRowsInAppenderator, boolean isPersistRequired) {
        this.segmentIdentifier = segmentIdentifier;
        this.numRowsInSegment = numRowsInSegment;
        this.totalNumRowsInAppenderator = totalNumRowsInAppenderator;
        this.isPersistRequired = isPersistRequired;
    }

    public boolean isOk() {
        return this.segmentIdentifier != null;
    }

    public SegmentIdWithShardSpec getSegmentIdentifier() {
        return this.segmentIdentifier;
    }

    public int getNumRowsInSegment() {
        return this.numRowsInSegment;
    }

    public long getTotalNumRowsInAppenderator() {
        return this.totalNumRowsInAppenderator;
    }

    public boolean isPersistRequired() {
        return this.isPersistRequired;
    }

    public boolean isPushRequired(@Nullable Integer maxRowsPerSegment, @Nullable Long maxTotalRows) {
        boolean overThreshold = false;
        if (maxRowsPerSegment != null) {
            boolean bl = overThreshold = this.getNumRowsInSegment() >= maxRowsPerSegment;
        }
        if (maxTotalRows != null) {
            overThreshold |= this.getTotalNumRowsInAppenderator() >= maxTotalRows;
        }
        return overThreshold;
    }
}

