/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.discovery;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.smile.SmileFactory;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.InputStream;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import org.apache.druid.client.JsonParserIterator;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.discovery.DataServerResponseHandler;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.guava.BaseSequence;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.Query;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.rpc.FixedServiceLocator;
import org.apache.druid.rpc.IgnoreHttpResponseHandler;
import org.apache.druid.rpc.RequestBuilder;
import org.apache.druid.rpc.ServiceClient;
import org.apache.druid.rpc.ServiceClientFactory;
import org.apache.druid.rpc.ServiceLocation;
import org.apache.druid.rpc.StandardRetryPolicy;
import org.apache.druid.utils.CloseableUtils;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.joda.time.Duration;

public class DataServerClient {
    private static final Logger log = new Logger(DataServerClient.class);
    private static final String BASE_PATH = "/druid/v2/";
    private static final Duration CANCELLATION_TIMEOUT = Duration.standardSeconds((long)5L);
    private final ServiceClient serviceClient;
    private final ObjectMapper objectMapper;
    private final ServiceLocation serviceLocation;

    public DataServerClient(ServiceClientFactory serviceClientFactory, ServiceLocation serviceLocation, ObjectMapper objectMapper) {
        this.serviceClient = serviceClientFactory.makeClient(serviceLocation.getHost(), new FixedServiceLocator(serviceLocation), StandardRetryPolicy.noRetries());
        this.serviceLocation = serviceLocation;
        this.objectMapper = objectMapper;
    }

    public <T> ListenableFuture<Sequence<T>> run(final Query<T> query, ResponseContext responseContext, final JavaType queryResultType, Closer closer) {
        RequestBuilder requestBuilder = new RequestBuilder(HttpMethod.POST, BASE_PATH);
        boolean isSmile = this.objectMapper.getFactory() instanceof SmileFactory;
        requestBuilder = isSmile ? requestBuilder.smileContent(this.objectMapper, query) : requestBuilder.jsonContent(this.objectMapper, query);
        if (log.isDebugEnabled()) {
            log.debug("Sending request to servers for query[%s], request[%s]", new Object[]{query.getId(), requestBuilder});
        }
        final ListenableFuture<InputStream> resultStreamFuture = this.serviceClient.asyncRequest(requestBuilder, new DataServerResponseHandler(query, responseContext, this.objectMapper));
        closer.register(() -> resultStreamFuture.cancel(true));
        Futures.addCallback(resultStreamFuture, (FutureCallback)new FutureCallback<InputStream>(){

            public void onSuccess(InputStream result) {
            }

            public void onFailure(Throwable t) {
                if (resultStreamFuture.isCancelled()) {
                    DataServerClient.this.cancelQuery(query.getId());
                }
            }
        }, (Executor)Execs.directExecutor());
        return FutureUtils.transform(resultStreamFuture, resultStream -> new BaseSequence(new BaseSequence.IteratorMaker<T, JsonParserIterator<T>>(){
            final /* synthetic */ InputStream val$resultStream;
            final /* synthetic */ Query val$query;
            {
                this.val$resultStream = inputStream;
                this.val$query = query;
            }

            public JsonParserIterator<T> make() {
                return new JsonParserIterator(queryResultType, (Future<InputStream>)Futures.immediateFuture((Object)this.val$resultStream), DataServerClient.BASE_PATH, this.val$query, DataServerClient.this.serviceLocation.getHost(), DataServerClient.this.objectMapper);
            }

            public void cleanup(JsonParserIterator<T> iterFromMake) {
                CloseableUtils.closeAndWrapExceptions(iterFromMake);
            }
        }));
    }

    private void cancelQuery(final String queryId) {
        if (queryId == null) {
            throw DruidException.defensive((String)"Null queryId", (Object[])new Object[0]);
        }
        String cancelPath = BASE_PATH + queryId;
        ListenableFuture<Void> cancelFuture = this.serviceClient.asyncRequest(new RequestBuilder(HttpMethod.DELETE, cancelPath).timeout(CANCELLATION_TIMEOUT), IgnoreHttpResponseHandler.INSTANCE);
        Futures.addCallback(cancelFuture, (FutureCallback)new FutureCallback<Void>(){

            public void onSuccess(Void result) {
            }

            public void onFailure(Throwable t) {
                log.noStackTrace().warn(t, "Failed to cancel query[%s] on server[%s]", new Object[]{queryId, DataServerClient.this.serviceLocation.getHostAndPort()});
            }
        }, (Executor)Execs.directExecutor());
    }
}

