/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.http;

import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import com.sun.jersey.spi.container.ResourceFilters;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SequencedCollection;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.druid.audit.AuditEntry;
import org.apache.druid.audit.AuditManager;
import org.apache.druid.client.CoordinatorServerView;
import org.apache.druid.client.DruidDataSource;
import org.apache.druid.client.DruidServer;
import org.apache.druid.client.ImmutableDruidDataSource;
import org.apache.druid.client.ImmutableSegmentLoadInfo;
import org.apache.druid.client.SegmentLoadInfo;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.common.utils.IdUtils;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.MapUtils;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.java.util.common.guava.FunctionalIterable;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.metadata.MetadataRuleManager;
import org.apache.druid.metadata.SegmentsMetadataManager;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.rpc.HttpResponseException;
import org.apache.druid.rpc.indexing.OverlordClient;
import org.apache.druid.rpc.indexing.SegmentUpdateResponse;
import org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.druid.server.coordinator.DruidCoordinator;
import org.apache.druid.server.coordinator.rules.LoadRule;
import org.apache.druid.server.coordinator.rules.Rule;
import org.apache.druid.server.http.InventoryViewUtils;
import org.apache.druid.server.http.SegmentsToUpdateFilter;
import org.apache.druid.server.http.ServletResourceUtils;
import org.apache.druid.server.http.security.DatasourceResourceFilter;
import org.apache.druid.server.security.AuthorizationUtils;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.TimelineLookup;
import org.apache.druid.timeline.TimelineObjectHolder;
import org.apache.druid.timeline.VersionedIntervalTimeline;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInterval;

@Path(value="/druid/coordinator/v1/datasources")
public class DataSourcesResource {
    private static final Logger log = new Logger(DataSourcesResource.class);
    private static final long DEFAULT_LOADSTATUS_INTERVAL_OFFSET = 1209600000L;
    private final CoordinatorServerView serverInventoryView;
    private final SegmentsMetadataManager segmentsMetadataManager;
    private final MetadataRuleManager metadataRuleManager;
    private final OverlordClient overlordClient;
    private final AuthorizerMapper authorizerMapper;
    private final DruidCoordinator coordinator;
    private final AuditManager auditManager;

    @Inject
    public DataSourcesResource(CoordinatorServerView serverInventoryView, SegmentsMetadataManager segmentsMetadataManager, MetadataRuleManager metadataRuleManager, OverlordClient overlordClient, AuthorizerMapper authorizerMapper, DruidCoordinator coordinator, AuditManager auditManager) {
        this.serverInventoryView = serverInventoryView;
        this.segmentsMetadataManager = segmentsMetadataManager;
        this.metadataRuleManager = metadataRuleManager;
        this.overlordClient = overlordClient;
        this.authorizerMapper = authorizerMapper;
        this.coordinator = coordinator;
        this.auditManager = auditManager;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getQueryableDataSources(@QueryParam(value="full") @Nullable String full, @QueryParam(value="simple") @Nullable String simple, @Context HttpServletRequest req) {
        Response.ResponseBuilder builder = Response.ok();
        SortedSet<ImmutableDruidDataSource> datasources = InventoryViewUtils.getSecuredDataSources(req, this.serverInventoryView, this.authorizerMapper);
        SequencedCollection<ImmutableDruidDataSource> entity = full != null ? datasources : (simple != null ? datasources.stream().map(this::makeSimpleDatasource).collect(Collectors.toList()) : datasources.stream().map(ImmutableDruidDataSource::getName).collect(Collectors.toList()));
        return builder.entity(entity).build();
    }

    @GET
    @Path(value="/{dataSourceName}")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response getQueryableDataSource(@PathParam(value="dataSourceName") String dataSourceName, @QueryParam(value="full") String full) {
        ImmutableDruidDataSource dataSource = this.getQueryableDataSource(dataSourceName);
        if (dataSource == null) {
            return DataSourcesResource.logAndCreateDataSourceNotFoundResponse(dataSourceName);
        }
        if (full != null) {
            return Response.ok((Object)dataSource).build();
        }
        return Response.ok(this.getSimpleDatasource(dataSourceName)).build();
    }

    @Deprecated
    @POST
    @Path(value="/{dataSourceName}")
    @Consumes(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response markAsUsedAllNonOvershadowedSegments(@PathParam(value="dataSourceName") String dataSourceName) {
        SegmentUpdateOperation metadataOperation = () -> this.segmentsMetadataManager.markAsUsedAllNonOvershadowedSegmentsInDataSource(dataSourceName);
        RemoteSegmentUpdateOperation remoteOperation = () -> this.overlordClient.markNonOvershadowedSegmentsAsUsed(dataSourceName);
        return DataSourcesResource.updateSegmentsViaOverlord(dataSourceName, remoteOperation).orUpdateMetadataIf404(metadataOperation);
    }

    @Deprecated
    @POST
    @Path(value="/{dataSourceName}/markUsed")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response markAsUsedNonOvershadowedSegments(@PathParam(value="dataSourceName") String dataSourceName, SegmentsToUpdateFilter payload) {
        if (payload == null || !payload.isValid()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid request payload. Specify either 'interval' or 'segmentIds', but not both. Optionally, include 'versions' only when 'interval' is provided.").build();
        }
        SegmentUpdateOperation metadataOperation = () -> {
            Interval interval = payload.getInterval();
            List<String> versions = payload.getVersions();
            if (interval != null) {
                return this.segmentsMetadataManager.markAsUsedNonOvershadowedSegmentsInInterval(dataSourceName, interval, versions);
            }
            Set<String> segmentIds = payload.getSegmentIds();
            if (segmentIds == null || segmentIds.isEmpty()) {
                return 0;
            }
            return this.segmentsMetadataManager.markAsUsedNonOvershadowedSegments(dataSourceName, IdUtils.getValidSegmentIds((String)dataSourceName, segmentIds));
        };
        RemoteSegmentUpdateOperation remoteOperation = () -> this.overlordClient.markNonOvershadowedSegmentsAsUsed(dataSourceName, payload);
        return DataSourcesResource.updateSegmentsViaOverlord(dataSourceName, remoteOperation).orUpdateMetadataIf404(metadataOperation);
    }

    @Deprecated
    @POST
    @Path(value="/{dataSourceName}/markUnused")
    @ResourceFilters(value={DatasourceResourceFilter.class})
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response markSegmentsAsUnused(@PathParam(value="dataSourceName") String dataSourceName, SegmentsToUpdateFilter payload, @Context HttpServletRequest req) {
        if (payload == null || !payload.isValid()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid request payload. Specify either 'interval' or 'segmentIds', but not both. Optionally, include 'versions' only when 'interval' is provided.").build();
        }
        SegmentUpdateOperation metadataOperation = () -> {
            int numUpdatedSegments;
            Interval interval = payload.getInterval();
            List<String> versions = payload.getVersions();
            if (interval != null) {
                numUpdatedSegments = this.segmentsMetadataManager.markAsUnusedSegmentsInInterval(dataSourceName, interval, versions);
            } else {
                Set segmentIds = payload.getSegmentIds().stream().map(idStr -> SegmentId.tryParse((String)dataSourceName, (String)idStr)).filter(Objects::nonNull).collect(Collectors.toSet());
                numUpdatedSegments = this.segmentsMetadataManager.markSegmentsAsUnused(segmentIds.stream().filter(segmentId -> segmentId.getDataSource().equals(dataSourceName)).collect(Collectors.toSet()));
            }
            this.auditManager.doAudit(AuditEntry.builder().key(dataSourceName).type("segment.markUnused").payload((Object)payload).auditInfo(AuthorizationUtils.buildAuditInfo(req)).request(AuthorizationUtils.buildRequestInfo("coordinator", req)).build());
            return numUpdatedSegments;
        };
        RemoteSegmentUpdateOperation remoteOperation = () -> this.overlordClient.markSegmentsAsUnused(dataSourceName, payload);
        return DataSourcesResource.updateSegmentsViaOverlord(dataSourceName, remoteOperation).orUpdateMetadataIf404(metadataOperation);
    }

    private static Response logAndCreateDataSourceNotFoundResponse(String dataSourceName) {
        log.warn("datasource[%s] not found", new Object[]{dataSourceName});
        return Response.noContent().build();
    }

    private static Response performSegmentUpdate(String dataSourceName, SegmentUpdateOperation operation) {
        try {
            int numChangedSegments = operation.perform();
            return Response.ok((Object)new SegmentUpdateResponse(numChangedSegments)).build();
        }
        catch (DruidException e) {
            return ServletResourceUtils.buildErrorResponseFrom(e);
        }
        catch (Exception e) {
            log.error((Throwable)e, "Error occurred while updating segments for datasource[%s]", new Object[]{dataSourceName});
            return Response.serverError().entity((Object)ImmutableMap.of((Object)"error", (Object)"Server error", (Object)"message", (Object)Throwables.getRootCause((Throwable)e).toString())).build();
        }
    }

    private static RemoteOrMetadataUpdate updateSegmentsViaOverlord(String dataSourceName, RemoteSegmentUpdateOperation operation) {
        return new RemoteOrMetadataUpdate(dataSourceName, operation);
    }

    @DELETE
    @Deprecated
    @Path(value="/{dataSourceName}")
    @ResourceFilters(value={DatasourceResourceFilter.class})
    @Produces(value={"application/json"})
    public Response markAsUnusedAllSegmentsOrKillUnusedSegmentsInInterval(@PathParam(value="dataSourceName") String dataSourceName, @QueryParam(value="kill") String kill, @QueryParam(value="interval") String interval, @Context HttpServletRequest req) {
        if (Boolean.parseBoolean(kill)) {
            return this.killUnusedSegmentsInInterval(dataSourceName, interval, req);
        }
        SegmentUpdateOperation metadataOperation = () -> {
            int numUpdatedSegments = this.segmentsMetadataManager.markAsUnusedAllSegmentsInDataSource(dataSourceName);
            if (numUpdatedSegments > 0) {
                this.auditManager.doAudit(AuditEntry.builder().key(dataSourceName).type("segment.markUnused").payload((Object)new SegmentUpdateResponse(numUpdatedSegments)).auditInfo(AuthorizationUtils.buildAuditInfo(req)).request(AuthorizationUtils.buildRequestInfo("coordinator", req)).build());
            }
            return numUpdatedSegments;
        };
        RemoteSegmentUpdateOperation remoteOperation = () -> this.overlordClient.markSegmentsAsUnused(dataSourceName);
        return DataSourcesResource.updateSegmentsViaOverlord(dataSourceName, remoteOperation).orUpdateMetadataIf404(metadataOperation);
    }

    @DELETE
    @Path(value="/{dataSourceName}/intervals/{interval}")
    @ResourceFilters(value={DatasourceResourceFilter.class})
    @Produces(value={"application/json"})
    public Response killUnusedSegmentsInInterval(@PathParam(value="dataSourceName") String dataSourceName, @PathParam(value="interval") String interval, @Context HttpServletRequest req) {
        if (StringUtils.contains((CharSequence)interval, (int)95)) {
            log.warn("Use interval with '/', not '_': [%s] given", new Object[]{interval});
        }
        Interval theInterval = Intervals.of((String)interval.replace('_', '/'));
        try {
            String killTaskId = (String)FutureUtils.getUnchecked(this.overlordClient.runKillTask("api-issued", dataSourceName, theInterval, null, null, null), (boolean)true);
            this.auditManager.doAudit(AuditEntry.builder().key(dataSourceName).type("segment.kill").payload((Object)ImmutableMap.of((Object)"killTaskId", (Object)killTaskId, (Object)"interval", (Object)theInterval)).auditInfo(AuthorizationUtils.buildAuditInfo(req)).request(AuthorizationUtils.buildRequestInfo("coordinator", req)).build());
            return Response.ok().build();
        }
        catch (Exception e) {
            return Response.serverError().entity((Object)ImmutableMap.of((Object)"error", (Object)"Exception occurred. Are you sure you have an indexing service?", (Object)"message", (Object)e.toString())).build();
        }
    }

    @GET
    @Path(value="/{dataSourceName}/intervals")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response getIntervalsWithServedSegmentsOrAllServedSegmentsPerIntervals(@PathParam(value="dataSourceName") String dataSourceName, @QueryParam(value="simple") String simple, @QueryParam(value="full") String full) {
        if (simple == null && full == null) {
            ImmutableDruidDataSource dataSource = this.getQueryableDataSource(dataSourceName);
            if (dataSource == null) {
                return DataSourcesResource.logAndCreateDataSourceNotFoundResponse(dataSourceName);
            }
            Comparator comparator = Comparators.intervalsByStartThenEnd().reversed();
            TreeSet intervals = new TreeSet(comparator);
            dataSource.getSegments().forEach(segment -> intervals.add(segment.getInterval()));
            return Response.ok(intervals).build();
        }
        return this.getServedSegmentsInInterval(dataSourceName, full != null, interval -> true);
    }

    @GET
    @Path(value="/{dataSourceName}/intervals/{interval}")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response getServedSegmentsInInterval(@PathParam(value="dataSourceName") String dataSourceName, @PathParam(value="interval") String interval, @QueryParam(value="simple") String simple, @QueryParam(value="full") String full) {
        Interval theInterval = Intervals.of((String)interval.replace('_', '/'));
        if (simple == null && full == null) {
            ImmutableDruidDataSource dataSource = this.getQueryableDataSource(dataSourceName);
            if (dataSource == null) {
                return DataSourcesResource.logAndCreateDataSourceNotFoundResponse(dataSourceName);
            }
            TreeSet<SegmentId> segmentIds = new TreeSet<SegmentId>();
            for (DataSegment dataSegment : dataSource.getSegments()) {
                if (!theInterval.contains((ReadableInterval)dataSegment.getInterval())) continue;
                segmentIds.add(dataSegment.getId());
            }
            return Response.ok(segmentIds).build();
        }
        return this.getServedSegmentsInInterval(dataSourceName, full != null, arg_0 -> ((Interval)theInterval).contains(arg_0));
    }

    @GET
    @Path(value="/{dataSourceName}/loadstatus")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response getDatasourceLoadstatus(@PathParam(value="dataSourceName") String dataSourceName, @QueryParam(value="forceMetadataRefresh") Boolean forceMetadataRefresh, @QueryParam(value="interval") @Nullable String interval, @QueryParam(value="simple") @Nullable String simple, @QueryParam(value="full") @Nullable String full, @QueryParam(value="computeUsingClusterView") @Nullable String computeUsingClusterView) {
        Interval theInterval;
        if (forceMetadataRefresh == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid request. forceMetadataRefresh must be specified").build();
        }
        if (interval == null) {
            long currentTimeInMs = System.currentTimeMillis();
            theInterval = Intervals.utc((long)(currentTimeInMs - 1209600000L), (long)currentTimeInMs);
        } else {
            theInterval = Intervals.of((String)interval.replace('_', '/'));
        }
        Optional<Iterable<DataSegment>> segments = this.segmentsMetadataManager.iterateAllUsedNonOvershadowedSegmentsForDatasourceInterval(dataSourceName, theInterval, forceMetadataRefresh);
        if (!segments.isPresent()) {
            return DataSourcesResource.logAndCreateDataSourceNotFoundResponse(dataSourceName);
        }
        if (Iterables.size((Iterable)((Iterable)segments.get())) == 0) {
            return Response.status((Response.Status)Response.Status.NO_CONTENT).entity((Object)"No used segment found for the given datasource and interval").build();
        }
        if (simple != null) {
            SegmentsLoadStatistics segmentsLoadStatistics = this.computeSegmentLoadStatistics((Iterable)segments.get());
            return Response.ok((Object)ImmutableMap.of((Object)dataSourceName, (Object)segmentsLoadStatistics.getNumUnavailableSegments())).build();
        }
        if (full != null) {
            Map<String, Object2LongMap<String>> segmentLoadMap = this.coordinator.getTierToDatasourceToUnderReplicatedCount((Iterable)segments.get(), computeUsingClusterView != null);
            if (segmentLoadMap.isEmpty()) {
                return Response.serverError().entity((Object)"Coordinator segment replicant lookup is not initialized yet. Try again later.").build();
            }
            return Response.ok(segmentLoadMap).build();
        }
        SegmentsLoadStatistics segmentsLoadStatistics = this.computeSegmentLoadStatistics((Iterable)segments.get());
        return Response.ok((Object)ImmutableMap.of((Object)dataSourceName, (Object)(100.0 * ((double)segmentsLoadStatistics.getNumLoadedSegments() / (double)segmentsLoadStatistics.getNumPublishedSegments())))).build();
    }

    private SegmentsLoadStatistics computeSegmentLoadStatistics(Iterable<DataSegment> segments) {
        Map<SegmentId, SegmentLoadInfo> segmentLoadInfos = this.serverInventoryView.getLoadInfoForAllSegments();
        int numPublishedSegments = 0;
        int numUnavailableSegments = 0;
        int numLoadedSegments = 0;
        for (DataSegment segment : segments) {
            ++numPublishedSegments;
            if (!segmentLoadInfos.containsKey(segment.getId())) {
                ++numUnavailableSegments;
                continue;
            }
            ++numLoadedSegments;
        }
        return new SegmentsLoadStatistics(numPublishedSegments, numUnavailableSegments, numLoadedSegments);
    }

    private Response getServedSegmentsInInterval(String dataSourceName, boolean full, Predicate<Interval> intervalFilter) {
        ImmutableDruidDataSource dataSource = this.getQueryableDataSource(dataSourceName);
        if (dataSource == null) {
            return DataSourcesResource.logAndCreateDataSourceNotFoundResponse(dataSourceName);
        }
        Comparator comparator = Comparators.intervalsByStartThenEnd().reversed();
        if (full) {
            TreeMap retVal = new TreeMap(comparator);
            for (DataSegment dataSegment : dataSource.getSegments()) {
                if (!intervalFilter.test(dataSegment.getInterval())) continue;
                Map segments = retVal.computeIfAbsent(dataSegment.getInterval(), i -> new HashMap());
                Pair<DataSegment, Set<String>> segmentAndServers = this.getServersWhereSegmentIsServed(dataSegment.getId());
                if (segmentAndServers == null) continue;
                segments.put(dataSegment.getId(), ImmutableMap.of((Object)"metadata", (Object)segmentAndServers.lhs, (Object)"servers", (Object)segmentAndServers.rhs));
            }
            return Response.ok(retVal).build();
        }
        TreeMap statsPerInterval = new TreeMap(comparator);
        for (DataSegment dataSegment : dataSource.getSegments()) {
            if (!intervalFilter.test(dataSegment.getInterval())) continue;
            Map properties = statsPerInterval.computeIfAbsent(dataSegment.getInterval(), i -> new EnumMap(SimpleProperties.class));
            properties.merge(SimpleProperties.size, dataSegment.getSize(), (a, b) -> (Long)a + (Long)b);
            properties.merge(SimpleProperties.count, 1, (a, b) -> (Integer)a + (Integer)b);
        }
        return Response.ok(statsPerInterval).build();
    }

    @GET
    @Path(value="/{dataSourceName}/segments")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response getAllServedSegments(@PathParam(value="dataSourceName") String dataSourceName, @QueryParam(value="full") String full) {
        ImmutableDruidDataSource dataSource = this.getQueryableDataSource(dataSourceName);
        if (dataSource == null) {
            return DataSourcesResource.logAndCreateDataSourceNotFoundResponse(dataSourceName);
        }
        Response.ResponseBuilder builder = Response.ok();
        if (full != null) {
            return builder.entity(dataSource.getSegments()).build();
        }
        return builder.entity((Object)Iterables.transform(dataSource.getSegments(), DataSegment::getId)).build();
    }

    @GET
    @Path(value="/{dataSourceName}/segments/{segmentId}")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response getServedSegment(@PathParam(value="dataSourceName") String dataSourceName, @PathParam(value="segmentId") String segmentId) {
        ImmutableDruidDataSource dataSource = this.getQueryableDataSource(dataSourceName);
        if (dataSource == null) {
            return DataSourcesResource.logAndCreateDataSourceNotFoundResponse(dataSourceName);
        }
        for (SegmentId possibleSegmentId : SegmentId.iteratePossibleParsingsWithDataSource((String)dataSourceName, (String)segmentId)) {
            Pair<DataSegment, Set<String>> retVal = this.getServersWhereSegmentIsServed(possibleSegmentId);
            if (retVal == null) continue;
            return Response.ok((Object)ImmutableMap.of((Object)"metadata", (Object)retVal.lhs, (Object)"servers", (Object)retVal.rhs)).build();
        }
        log.warn("Segment id [%s] is unknown", new Object[]{segmentId});
        return Response.noContent().build();
    }

    @Deprecated
    @DELETE
    @Path(value="/{dataSourceName}/segments/{segmentId}")
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response markSegmentAsUnused(@PathParam(value="dataSourceName") String dataSourceName, @PathParam(value="segmentId") String segmentIdString) {
        SegmentId segmentId = SegmentId.tryParse((String)dataSourceName, (String)segmentIdString);
        if (segmentId == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)org.apache.druid.java.util.common.StringUtils.format((String)"Could not parse Segment ID[%s] for DataSource[%s]", (Object[])new Object[]{segmentIdString, dataSourceName})).build();
        }
        SegmentUpdateOperation metadataOperation = () -> this.segmentsMetadataManager.markSegmentAsUnused(segmentId) ? 1 : 0;
        RemoteSegmentUpdateOperation remoteOperation = () -> this.overlordClient.markSegmentAsUnused(segmentId);
        return DataSourcesResource.updateSegmentsViaOverlord(dataSourceName, remoteOperation).orUpdateMetadataIf404(metadataOperation);
    }

    @Deprecated
    @POST
    @Path(value="/{dataSourceName}/segments/{segmentId}")
    @Consumes(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response markSegmentAsUsed(@PathParam(value="dataSourceName") String dataSourceName, @PathParam(value="segmentId") String segmentIdString) {
        SegmentId segmentId = SegmentId.tryParse((String)dataSourceName, (String)segmentIdString);
        if (segmentId == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)org.apache.druid.java.util.common.StringUtils.format((String)"Could not parse Segment ID[%s] for DataSource[%s]", (Object[])new Object[]{segmentIdString, dataSourceName})).build();
        }
        SegmentUpdateOperation metadataOperation = () -> this.segmentsMetadataManager.markSegmentAsUsed(segmentIdString) ? 1 : 0;
        RemoteSegmentUpdateOperation remoteOperation = () -> this.overlordClient.markSegmentAsUsed(segmentId);
        return DataSourcesResource.updateSegmentsViaOverlord(dataSourceName, remoteOperation).orUpdateMetadataIf404(metadataOperation);
    }

    @GET
    @Path(value="/{dataSourceName}/tiers")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response getTiersWhereSegmentsAreServed(@PathParam(value="dataSourceName") String dataSourceName) {
        HashSet<String> retVal = new HashSet<String>();
        for (DruidServer druidServer : this.serverInventoryView.getInventory()) {
            if (druidServer.getDataSource(dataSourceName) == null) continue;
            retVal.add(druidServer.getTier());
        }
        return Response.ok(retVal).build();
    }

    @Nullable
    private ImmutableDruidDataSource getQueryableDataSource(String dataSourceName) {
        List dataSources = this.serverInventoryView.getInventory().stream().map(server -> server.getDataSource(dataSourceName)).filter(Objects::nonNull).collect(Collectors.toList());
        if (dataSources.isEmpty()) {
            return null;
        }
        TreeMap<SegmentId, DataSegment> segmentMap = new TreeMap<SegmentId, DataSegment>();
        for (DruidDataSource dataSource : dataSources) {
            Collection<DataSegment> segments = dataSource.getSegments();
            for (DataSegment segment : segments) {
                segmentMap.put(segment.getId(), segment);
            }
        }
        return new ImmutableDruidDataSource(dataSourceName, Collections.emptyMap(), segmentMap);
    }

    @Nullable
    private Pair<DataSegment, Set<String>> getServersWhereSegmentIsServed(SegmentId segmentId) {
        DataSegment theSegment = null;
        HashSet<String> servers = new HashSet<String>();
        for (DruidServer druidServer : this.serverInventoryView.getInventory()) {
            DataSegment currSegment = druidServer.getSegment(segmentId);
            if (currSegment == null) continue;
            theSegment = currSegment;
            servers.add(druidServer.getHost());
        }
        if (theSegment == null) {
            return null;
        }
        return new Pair(theSegment, servers);
    }

    private Map<String, Object> makeSimpleDatasource(ImmutableDruidDataSource input) {
        return new ImmutableMap.Builder().put((Object)"name", (Object)input.getName()).put((Object)"properties", this.getSimpleDatasource(input.getName())).build();
    }

    private Map<String, Map<String, Object>> getSimpleDatasource(String dataSourceName) {
        HashMap<String, HashMap<String, Integer>> tiers = new HashMap<String, HashMap<String, Integer>>();
        HashMap<String, Number> segments = new HashMap<String, Number>();
        ImmutableMap retVal = ImmutableMap.of((Object)"tiers", tiers, (Object)"segments", segments);
        HashSet<SegmentId> totalDistinctSegments = new HashSet<SegmentId>();
        HashMap<String, HashSet> tierDistinctSegments = new HashMap<String, HashSet>();
        long totalSegmentSize = 0L;
        long totalReplicatedSize = 0L;
        DateTime minTime = DateTimes.MAX;
        DateTime maxTime = DateTimes.MIN;
        for (DruidServer druidServer : this.serverInventoryView.getInventory()) {
            DruidDataSource druidDataSource = druidServer.getDataSource(dataSourceName);
            String tier = druidServer.getTier();
            if (druidDataSource == null) continue;
            tierDistinctSegments.computeIfAbsent(tier, t -> new HashSet());
            long dataSourceSegmentSize = 0L;
            long replicatedSegmentSize = 0L;
            for (DataSegment dataSegment : druidDataSource.getSegments()) {
                if (!((HashSet)tierDistinctSegments.get(tier)).contains(dataSegment.getId())) {
                    dataSourceSegmentSize += dataSegment.getSize();
                    ((HashSet)tierDistinctSegments.get(tier)).add(dataSegment.getId());
                }
                if (totalDistinctSegments.add(dataSegment.getId())) {
                    totalSegmentSize += dataSegment.getSize();
                    minTime = DateTimes.min((DateTime)minTime, (DateTime)dataSegment.getInterval().getStart());
                    maxTime = DateTimes.max((DateTime)maxTime, (DateTime)dataSegment.getInterval().getEnd());
                }
                totalReplicatedSize += dataSegment.getSize();
                replicatedSegmentSize += dataSegment.getSize();
            }
            HashMap<String, Integer> tierStats = (HashMap<String, Integer>)tiers.get(tier);
            if (tierStats == null) {
                tierStats = new HashMap<String, Integer>();
                tiers.put(druidServer.getTier(), tierStats);
            }
            tierStats.put("segmentCount", ((HashSet)tierDistinctSegments.get(tier)).size());
            long segmentSize = MapUtils.getLong(tierStats, (String)"size", (Long)0L);
            tierStats.put("size", (Integer)(segmentSize + dataSourceSegmentSize));
            long replicatedSize = MapUtils.getLong(tierStats, (String)"replicatedSize", (Long)0L);
            tierStats.put("replicatedSize", (Integer)(replicatedSize + replicatedSegmentSize));
        }
        segments.put("count", totalDistinctSegments.size());
        segments.put("size", totalSegmentSize);
        segments.put("replicatedSize", totalReplicatedSize);
        segments.put("minTime", (Number)minTime);
        segments.put("maxTime", (Number)maxTime);
        return retVal;
    }

    @GET
    @Path(value="/{dataSourceName}/intervals/{interval}/serverview")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response getServedSegmentsInInterval(@PathParam(value="dataSourceName") String dataSourceName, @PathParam(value="interval") String interval, @QueryParam(value="partial") boolean partial) {
        VersionedIntervalTimeline<String, SegmentLoadInfo> timeline = this.serverInventoryView.getTimeline((DataSource)new TableDataSource(dataSourceName));
        Interval theInterval = Intervals.of((String)interval.replace('_', '/'));
        if (timeline == null) {
            log.debug("No timeline found for datasource[%s]", new Object[]{dataSourceName});
            return Response.ok(new ArrayList()).build();
        }
        return Response.ok(this.prepareServedSegmentsInInterval((TimelineLookup<String, SegmentLoadInfo>)timeline, theInterval)).build();
    }

    private Iterable<ImmutableSegmentLoadInfo> prepareServedSegmentsInInterval(TimelineLookup<String, SegmentLoadInfo> dataSourceServingTimeline, Interval interval) {
        List lookup = dataSourceServingTimeline.lookupWithIncompletePartitions(interval);
        return FunctionalIterable.create((Iterable)lookup).transformCat(input -> Iterables.transform((Iterable)input.getObject(), chunk -> ((SegmentLoadInfo)chunk.getObject()).toImmutableSegmentLoadInfo()));
    }

    @GET
    @Path(value="/{dataSourceName}/handoffComplete")
    @Produces(value={"application/json"})
    @ResourceFilters(value={DatasourceResourceFilter.class})
    public Response isHandOffComplete(@PathParam(value="dataSourceName") String dataSourceName, @QueryParam(value="interval") String interval, @QueryParam(value="partitionNumber") int partitionNumber, @QueryParam(value="version") String version) {
        try {
            List<Rule> rules = this.metadataRuleManager.getRulesWithDefault(dataSourceName);
            Interval theInterval = Intervals.of((String)interval);
            SegmentDescriptor descriptor = new SegmentDescriptor(theInterval, version, partitionNumber);
            DateTime now = DateTimes.nowUtc();
            boolean eligibleForLoad = false;
            for (Rule rule : rules) {
                if (!rule.appliesTo(theInterval, now)) continue;
                eligibleForLoad = rule instanceof LoadRule && ((LoadRule)rule).shouldMatchingSegmentBeLoaded();
                break;
            }
            if (!eligibleForLoad) {
                return Response.ok((Object)true).build();
            }
            VersionedIntervalTimeline<String, SegmentLoadInfo> timeline = this.serverInventoryView.getTimeline((DataSource)new TableDataSource(dataSourceName));
            if (timeline == null) {
                log.error("No timeline found for datasource[%s]", new Object[]{dataSourceName});
                return Response.ok((Object)false).build();
            }
            List timelineObjects = timeline.lookup(Intervals.of((String)interval));
            if (!timelineObjects.isEmpty() && ((String)((TimelineObjectHolder)timelineObjects.get(0)).getVersion()).compareTo(version) > 0) {
                return Response.ok((Object)true).build();
            }
            Iterable<ImmutableSegmentLoadInfo> servedSegmentsInInterval = this.prepareServedSegmentsInInterval((TimelineLookup<String, SegmentLoadInfo>)timeline, theInterval);
            if (DataSourcesResource.isSegmentLoaded(servedSegmentsInInterval, descriptor)) {
                return Response.ok((Object)true).build();
            }
            return Response.ok((Object)false).build();
        }
        catch (Exception e) {
            log.error((Throwable)e, "Error while handling hand off check request", new Object[0]);
            return Response.serverError().entity((Object)ImmutableMap.of((Object)"error", (Object)e.toString())).build();
        }
    }

    static boolean isSegmentLoaded(Iterable<ImmutableSegmentLoadInfo> servedSegments, SegmentDescriptor descriptor) {
        for (ImmutableSegmentLoadInfo segmentLoadInfo : servedSegments) {
            if (!segmentLoadInfo.getSegment().getInterval().contains((ReadableInterval)descriptor.getInterval()) || segmentLoadInfo.getSegment().getShardSpec().getPartitionNum() != descriptor.getPartitionNumber() || segmentLoadInfo.getSegment().getVersion().compareTo(descriptor.getVersion()) < 0 || !Iterables.any(segmentLoadInfo.getServers(), DruidServerMetadata::isSegmentReplicationTarget)) continue;
            return true;
        }
        return false;
    }

    private static interface SegmentUpdateOperation {
        public int perform();
    }

    private static interface RemoteSegmentUpdateOperation {
        public ListenableFuture<SegmentUpdateResponse> perform();
    }

    private static class RemoteOrMetadataUpdate {
        private final String dataSourceName;
        private final RemoteSegmentUpdateOperation remoteOperation;

        private RemoteOrMetadataUpdate(String dataSourceName, RemoteSegmentUpdateOperation remoteOperation) {
            this.dataSourceName = dataSourceName;
            this.remoteOperation = remoteOperation;
        }

        Response orUpdateMetadataIf404(SegmentUpdateOperation operation) {
            try {
                SegmentUpdateResponse response = (SegmentUpdateResponse)FutureUtils.getUnchecked(this.remoteOperation.perform(), (boolean)true);
                return Response.ok((Object)response).build();
            }
            catch (DruidException e) {
                return ServletResourceUtils.buildErrorResponseFrom(e);
            }
            catch (Exception e) {
                HttpResponseStatus status;
                Throwable rootCause = Throwables.getRootCause((Throwable)e);
                if (rootCause instanceof HttpResponseException && (status = ((HttpResponseException)rootCause).getResponse().getStatus()).getCode() == 404) {
                    log.info("Could not update segments via Overlord API. Updating metadata store directly.", new Object[0]);
                    return DataSourcesResource.performSegmentUpdate(this.dataSourceName, operation);
                }
                log.error((Throwable)e, "Error occurred while updating segments for datasource[%s]", new Object[]{this.dataSourceName});
                return Response.serverError().entity((Object)ImmutableMap.of((Object)"error", (Object)"Unknown server error", (Object)"message", (Object)rootCause.toString())).build();
            }
        }
    }

    private static class SegmentsLoadStatistics {
        private final int numPublishedSegments;
        private final int numUnavailableSegments;
        private final int numLoadedSegments;

        SegmentsLoadStatistics(int numPublishedSegments, int numUnavailableSegments, int numLoadedSegments) {
            this.numPublishedSegments = numPublishedSegments;
            this.numUnavailableSegments = numUnavailableSegments;
            this.numLoadedSegments = numLoadedSegments;
        }

        public int getNumPublishedSegments() {
            return this.numPublishedSegments;
        }

        public int getNumUnavailableSegments() {
            return this.numUnavailableSegments;
        }

        public int getNumLoadedSegments() {
            return this.numLoadedSegments;
        }
    }

    static enum SimpleProperties {
        size,
        count;

    }
}

