/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.remote;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.io.File;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.druid.data.input.impl.prefetch.ObjectOpenFunction;
import org.apache.druid.storage.remote.ChunkingStorageConnector;

public class ChunkingStorageConnectorParameters<T> {
    private final long start;
    private final long end;
    private final String cloudStoragePath;
    private final ChunkingStorageConnector.GetObjectFromRangeFunction<T> objectSupplier;
    private final ObjectOpenFunction<T> objectOpenFunction;
    private final Predicate<Throwable> retryCondition;
    private final int maxRetry;
    private final Supplier<File> tempDirSupplier;

    public ChunkingStorageConnectorParameters(long start, long end, String cloudStoragePath, ChunkingStorageConnector.GetObjectFromRangeFunction<T> objectSupplier, ObjectOpenFunction<T> objectOpenFunction, Predicate<Throwable> retryCondition, int maxRetry, Supplier<File> tempDirSupplier) {
        this.start = start;
        this.end = end;
        this.cloudStoragePath = cloudStoragePath;
        this.objectSupplier = objectSupplier;
        this.objectOpenFunction = objectOpenFunction;
        this.retryCondition = retryCondition;
        this.maxRetry = maxRetry;
        this.tempDirSupplier = tempDirSupplier;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public String getCloudStoragePath() {
        return this.cloudStoragePath;
    }

    public ChunkingStorageConnector.GetObjectFromRangeFunction<T> getObjectSupplier() {
        return this.objectSupplier;
    }

    public ObjectOpenFunction<T> getObjectOpenFunction() {
        return this.objectOpenFunction;
    }

    public Predicate<Throwable> getRetryCondition() {
        return this.retryCondition;
    }

    public int getMaxRetry() {
        return this.maxRetry;
    }

    public Supplier<File> getTempDirSupplier() {
        return this.tempDirSupplier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChunkingStorageConnectorParameters that = (ChunkingStorageConnectorParameters)o;
        return this.start == that.start && this.end == that.end && this.maxRetry == that.maxRetry && Objects.equals(this.cloudStoragePath, that.cloudStoragePath) && Objects.equals(this.objectSupplier, that.objectSupplier) && Objects.equals(this.objectOpenFunction, that.objectOpenFunction) && Objects.equals(this.retryCondition, that.retryCondition) && Objects.equals(this.tempDirSupplier, that.tempDirSupplier);
    }

    public int hashCode() {
        return Objects.hash(this.start, this.end, this.cloudStoragePath, this.objectSupplier, this.objectOpenFunction, this.retryCondition, this.maxRetry, this.tempDirSupplier);
    }

    public static class Builder<T> {
        private long start;
        private long end;
        private String cloudStoragePath;
        private ChunkingStorageConnector.GetObjectFromRangeFunction<T> objectSupplier;
        private ObjectOpenFunction<T> objectOpenFunction;
        private Predicate<Throwable> retryCondition;
        private int maxRetry;
        private Supplier<File> tempDirSupplier;

        public Builder<T> start(long start) {
            this.start = start;
            return this;
        }

        public Builder<T> end(long end) {
            this.end = end;
            return this;
        }

        public Builder<T> cloudStoragePath(String cloudStoragePath) {
            this.cloudStoragePath = cloudStoragePath;
            return this;
        }

        public Builder<T> objectSupplier(ChunkingStorageConnector.GetObjectFromRangeFunction<T> objectSupplier) {
            this.objectSupplier = objectSupplier;
            return this;
        }

        public Builder<T> objectOpenFunction(ObjectOpenFunction<T> objectOpenFunction) {
            this.objectOpenFunction = objectOpenFunction;
            return this;
        }

        public Builder<T> retryCondition(Predicate<Throwable> retryCondition) {
            this.retryCondition = retryCondition;
            return this;
        }

        public Builder<T> maxRetry(int maxRetry) {
            this.maxRetry = maxRetry;
            return this;
        }

        public Builder<T> tempDirSupplier(Supplier<File> tempDirSupplier) {
            this.tempDirSupplier = tempDirSupplier;
            return this;
        }

        public ChunkingStorageConnectorParameters<T> build() {
            Preconditions.checkArgument((this.start >= 0L ? 1 : 0) != 0, (String)"'start' not provided or an incorrect value [%s] passed", (long)this.start);
            Preconditions.checkArgument((this.end >= 0L ? 1 : 0) != 0, (String)"'end' not provided or an incorrect value [%s] passed", (long)this.end);
            Preconditions.checkArgument((this.start <= this.end ? 1 : 0) != 0, (Object)"'start' should not be greater than 'end'");
            Preconditions.checkArgument((this.maxRetry >= 0 ? 1 : 0) != 0, (String)"'maxRetry' not provided or an incorrect value [%s] passed", (int)this.maxRetry);
            return new ChunkingStorageConnectorParameters(this.start, this.end, (String)Preconditions.checkNotNull((Object)this.cloudStoragePath, (Object)"'cloudStoragePath' not supplied"), (ChunkingStorageConnector.GetObjectFromRangeFunction)Preconditions.checkNotNull(this.objectSupplier, (Object)"'objectSupplier' not supplied"), (ObjectOpenFunction)Preconditions.checkNotNull(this.objectOpenFunction, (Object)"'objectOpenFunction' not supplied"), (Predicate<Throwable>)((Predicate)Preconditions.checkNotNull(this.retryCondition, (Object)"'retryCondition' not supplied")), this.maxRetry, (Supplier)Preconditions.checkNotNull(this.tempDirSupplier, (Object)"'tempDirSupplier' not supplied"));
        }
    }
}

