/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.serde.cell;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import org.apache.druid.segment.serde.cell.IntSerializer;
import org.apache.druid.segment.serde.cell.NumberSerializer;
import org.apache.druid.segment.writeout.WriteOutBytes;

public class IndexWriter {
    private final WriteOutBytes outBytes;
    private final NumberSerializer positionSerializer;
    private final NumberSerializer indexSizeSerializer;
    private boolean open = true;
    private long position = 0L;

    public IndexWriter(WriteOutBytes outBytes, NumberSerializer positionSerializer, NumberSerializer indexSizeSerializer) {
        this.outBytes = outBytes;
        this.positionSerializer = positionSerializer;
        this.indexSizeSerializer = indexSizeSerializer;
    }

    public IndexWriter(WriteOutBytes outBytes, NumberSerializer positionSerializer) {
        this(outBytes, positionSerializer, new IntSerializer());
    }

    public void persistAndIncrement(int increment) throws IOException {
        Preconditions.checkArgument((increment >= 0 ? 1 : 0) != 0, (Object)"increment must be non-negative");
        Preconditions.checkState((boolean)this.open, (Object)"peristAndIncrement() must be called when open");
        this.outBytes.write(this.positionSerializer.serialize(this.position));
        this.position += (long)increment;
    }

    public void close() throws IOException {
        this.outBytes.write(this.positionSerializer.serialize(this.position));
        this.open = false;
    }

    public void transferTo(WritableByteChannel channel) throws IOException {
        channel.write(this.indexSizeSerializer.serialize(this.outBytes.size()));
        this.outBytes.writeTo(channel);
    }

    public long getSerializedSize() {
        return this.indexSizeSerializer.getSerializedSize() + Ints.checkedCast((long)this.outBytes.size());
    }
}

