/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.serde;

import com.google.common.base.Supplier;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.segment.IndexMerger;
import org.apache.druid.segment.column.ColumnBuilder;
import org.apache.druid.segment.column.ComplexColumn;
import org.apache.druid.segment.data.CompressedVariableSizedBlobColumnSupplier;
import org.apache.druid.segment.data.ObjectStrategy;
import org.apache.druid.segment.file.SegmentFileMapper;
import org.apache.druid.segment.serde.ColumnSerializerUtils;
import org.apache.druid.segment.serde.ComplexColumnMetadata;
import org.apache.druid.segment.serde.CompressedComplexColumn;
import org.apache.druid.segment.serde.NestedCommonFormatColumnPartSerde;

public class CompressedComplexColumnSupplier<T>
implements Supplier<ComplexColumn> {
    private final String typeName;
    private final ObjectStrategy<T> objectStrategy;
    private final CompressedVariableSizedBlobColumnSupplier compressedColumnSupplier;
    private final ImmutableBitmap nullValues;

    public static <T> CompressedComplexColumnSupplier<T> read(ByteBuffer bb, ColumnBuilder columnBuilder, String typeName, ObjectStrategy<T> objectStrategy) {
        byte version = bb.get();
        if (version == 0) {
            try {
                ImmutableBitmap nullValues;
                ComplexColumnMetadata metadata = (ComplexColumnMetadata)ColumnSerializerUtils.SMILE_MAPPER.readValue(IndexMerger.SERIALIZER_UTILS.readString(bb), ComplexColumnMetadata.class);
                SegmentFileMapper mapper = columnBuilder.getFileMapper();
                ByteBuffer fileBuffer = NestedCommonFormatColumnPartSerde.loadInternalFile(mapper, metadata.getFileNameBase(), "__complexColumn");
                CompressedVariableSizedBlobColumnSupplier compressedColumnSupplier = CompressedVariableSizedBlobColumnSupplier.fromByteBuffer(ColumnSerializerUtils.getInternalFileName(metadata.getFileNameBase(), "__complexColumn"), fileBuffer, metadata.getByteOrder(), ByteOrder.BIG_ENDIAN, objectStrategy.readRetainsBufferReference(), mapper);
                if (metadata.hasNulls().booleanValue()) {
                    columnBuilder.setHasNulls(true);
                    ByteBuffer nullIndexBuffer = NestedCommonFormatColumnPartSerde.loadInternalFile(mapper, metadata.getFileNameBase(), "__nullIndex");
                    nullValues = metadata.getBitmapSerdeFactory().getObjectStrategy().fromByteBufferWithSize(nullIndexBuffer);
                } else {
                    nullValues = metadata.getBitmapSerdeFactory().getBitmapFactory().makeEmptyImmutableBitmap();
                }
                return new CompressedComplexColumnSupplier<T>(typeName, objectStrategy, compressedColumnSupplier, nullValues);
            }
            catch (IOException ex) {
                throw new RE(ex, "Failed to deserialize V%s column.", version);
            }
        }
        throw new RE("Unknown version " + version, new Object[0]);
    }

    private CompressedComplexColumnSupplier(String typeName, ObjectStrategy<T> objectStrategy, CompressedVariableSizedBlobColumnSupplier compressedColumnSupplier, ImmutableBitmap nullValues) {
        this.typeName = typeName;
        this.objectStrategy = objectStrategy;
        this.compressedColumnSupplier = compressedColumnSupplier;
        this.nullValues = nullValues;
    }

    public ComplexColumn get() {
        return new CompressedComplexColumn<T>(this.typeName, this.compressedColumnSupplier.get(), this.nullValues, this.objectStrategy);
    }

    public ImmutableBitmap getNullValues() {
        return this.nullValues;
    }
}

