/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join.table;

import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.ints.IntBidirectionalIterator;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.query.filter.InDimFilter;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.join.JoinConditionAnalysis;
import org.apache.druid.segment.join.JoinMatcher;
import org.apache.druid.segment.join.Joinable;
import org.apache.druid.segment.join.table.IndexedTable;
import org.apache.druid.segment.join.table.IndexedTableColumnSelectorFactory;
import org.apache.druid.segment.join.table.IndexedTableDimensionSelector;
import org.apache.druid.segment.join.table.IndexedTableJoinMatcher;

public class IndexedTableJoinable
implements Joinable {
    private final IndexedTable table;

    public IndexedTableJoinable(IndexedTable table) {
        this.table = table;
    }

    @Override
    public List<String> getAvailableColumns() {
        return this.table.rowSignature().getColumnNames();
    }

    @Override
    public int getCardinality(String columnName) {
        if (this.table.rowSignature().contains(columnName)) {
            return IndexedTableDimensionSelector.computeDimensionSelectorCardinality(this.table);
        }
        return 1;
    }

    @Override
    @Nullable
    public ColumnCapabilities getColumnCapabilities(String columnName) {
        return IndexedTableColumnSelectorFactory.columnCapabilities(this.table, columnName);
    }

    @Override
    public JoinMatcher makeJoinMatcher(ColumnSelectorFactory leftColumnSelectorFactory, JoinConditionAnalysis condition, boolean remainderNeeded, Closer closer) {
        return new IndexedTableJoinMatcher(this.table, leftColumnSelectorFactory, condition, remainderNeeded, closer);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Joinable.ColumnValuesWithUniqueFlag getMatchableColumnValues(String columnName, boolean includeNull, int maxNumValues) {
        int columnPosition = this.table.rowSignature().indexOf(columnName);
        InDimFilter.ValuesSet matchableValues = InDimFilter.ValuesSet.create();
        if (columnPosition < 0) {
            return new Joinable.ColumnValuesWithUniqueFlag((Set<String>)((Object)matchableValues), false);
        }
        try (IndexedTable.Reader reader = this.table.columnReader(columnPosition);){
            boolean allUnique = true;
            for (int i = 0; i < this.table.numRows(); ++i) {
                String s = DimensionHandlerUtils.convertObjectToString(reader.read(i));
                if (!includeNull && s == null) continue;
                if (!matchableValues.add(s)) {
                    allUnique = false;
                }
                if (matchableValues.size() <= maxNumValues) continue;
                Joinable.ColumnValuesWithUniqueFlag columnValuesWithUniqueFlag = new Joinable.ColumnValuesWithUniqueFlag((Set<String>)ImmutableSet.of(), false);
                return columnValuesWithUniqueFlag;
            }
            Joinable.ColumnValuesWithUniqueFlag columnValuesWithUniqueFlag = new Joinable.ColumnValuesWithUniqueFlag((Set<String>)((Object)matchableValues), allUnique);
            return columnValuesWithUniqueFlag;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<InDimFilter.ValuesSet> getCorrelatedColumnValues(String searchColumnName, String searchColumnValue, String retrievalColumnName, long maxCorrelationSetSize, boolean allowNonKeyColumnSearch) {
        int filterColumnPosition = this.table.rowSignature().indexOf(searchColumnName);
        int correlatedColumnPosition = this.table.rowSignature().indexOf(retrievalColumnName);
        if (filterColumnPosition < 0) return Optional.empty();
        if (correlatedColumnPosition < 0) {
            return Optional.empty();
        }
        try (Closer closer = Closer.create();){
            IndexedTable.Reader correlatedColumnReader;
            IndexedTable.Reader dimNameReader;
            InDimFilter.ValuesSet correlatedValues = InDimFilter.ValuesSet.create();
            if (!this.table.keyColumns().contains(searchColumnName)) {
                if (!allowNonKeyColumnSearch) {
                    Optional<InDimFilter.ValuesSet> index = Optional.empty();
                    return index;
                }
                dimNameReader = this.table.columnReader(filterColumnPosition);
                correlatedColumnReader = this.table.columnReader(correlatedColumnPosition);
                closer.register(dimNameReader);
                closer.register(correlatedColumnReader);
            } else {
                IndexedTable.Index index = this.table.columnIndex(filterColumnPosition);
                IndexedTable.Reader reader = this.table.columnReader(correlatedColumnPosition);
                closer.register(reader);
                IntSortedSet rowIndex = index.find(searchColumnValue);
                IntBidirectionalIterator rowIterator = rowIndex.iterator();
                do {
                    if (!rowIterator.hasNext()) {
                        Optional<InDimFilter.ValuesSet> rowNum = Optional.of(correlatedValues);
                        return rowNum;
                    }
                    int rowNum = rowIterator.nextInt();
                    String correlatedDimVal = DimensionHandlerUtils.convertObjectToString(reader.read(rowNum));
                    correlatedValues.add(correlatedDimVal);
                } while ((long)correlatedValues.size() <= maxCorrelationSetSize);
                Optional<InDimFilter.ValuesSet> optional = Optional.empty();
                return optional;
            }
            for (int i = 0; i < this.table.numRows(); ++i) {
                String dimVal = Objects.toString(dimNameReader.read(i), null);
                if (!searchColumnValue.equals(dimVal)) continue;
                String correlatedDimVal = DimensionHandlerUtils.convertObjectToString(correlatedColumnReader.read(i));
                correlatedValues.add(correlatedDimVal);
                if ((long)correlatedValues.size() <= maxCorrelationSetSize) continue;
                Optional<InDimFilter.ValuesSet> optional = Optional.empty();
                return optional;
            }
            Optional<InDimFilter.ValuesSet> optional = Optional.of(correlatedValues);
            return optional;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Optional<Closeable> acquireReference() {
        return this.table.acquireReference();
    }
}

