/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import com.google.common.primitives.Ints;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import javax.annotation.Nullable;
import org.apache.druid.common.utils.ByteUtils;
import org.apache.druid.segment.data.SingleValueColumnarIntsSerializer;
import org.apache.druid.segment.data.VSizeColumnarInts;
import org.apache.druid.segment.file.SegmentFileBuilder;
import org.apache.druid.segment.serde.MetaSerdeHelper;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;
import org.apache.druid.segment.writeout.WriteOutBytes;

public class VSizeColumnarIntsSerializer
extends SingleValueColumnarIntsSerializer {
    private static final byte VERSION = 0;
    private static final MetaSerdeHelper<VSizeColumnarIntsSerializer> META_SERDE_HELPER = MetaSerdeHelper.firstWriteByte(x -> 0).writeByte(x -> ByteUtils.checkedCast(x.numBytes)).writeInt(x -> Ints.checkedCast((long)x.valuesOut.size()));
    private final SegmentWriteOutMedium segmentWriteOutMedium;
    private final int numBytes;
    private final ByteBuffer helperBuffer = ByteBuffer.allocate(4);
    private boolean bufPaddingWritten = false;
    @Nullable
    private WriteOutBytes valuesOut = null;

    public VSizeColumnarIntsSerializer(SegmentWriteOutMedium segmentWriteOutMedium, int maxValue) {
        this.segmentWriteOutMedium = segmentWriteOutMedium;
        this.numBytes = VSizeColumnarInts.getNumBytesForMax(maxValue);
    }

    @Override
    public void open() throws IOException {
        this.valuesOut = this.segmentWriteOutMedium.makeWriteOutBytes();
    }

    @Override
    public void addValue(int val) throws IOException {
        if (this.bufPaddingWritten) {
            throw new IllegalStateException("written out already");
        }
        this.helperBuffer.putInt(0, val);
        this.valuesOut.write(this.helperBuffer.array(), 4 - this.numBytes, this.numBytes);
    }

    @Override
    public long getSerializedSize() throws IOException {
        this.writeBufPadding();
        return (long)META_SERDE_HELPER.size(this) + this.valuesOut.size();
    }

    @Override
    public void writeTo(WritableByteChannel channel, SegmentFileBuilder fileBuilder) throws IOException {
        this.writeBufPadding();
        META_SERDE_HELPER.writeTo(channel, this);
        this.valuesOut.writeTo(channel);
    }

    private void writeBufPadding() throws IOException {
        if (!this.bufPaddingWritten) {
            byte[] bufPadding = new byte[4 - this.numBytes];
            this.valuesOut.write(bufPadding);
            this.bufPaddingWritten = true;
        }
    }
}

