/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import java.util.Collections;
import java.util.List;
import org.apache.druid.query.Order;
import org.apache.druid.query.OrderBy;
import org.apache.druid.segment.CursorBuildSpec;

public class Cursors {
    private static final List<OrderBy> TIME_ASCENDING_ORDER = Collections.singletonList(OrderBy.ascending("__time"));
    private static final List<OrderBy> TIME_DESCENDING_ORDER = Collections.singletonList(OrderBy.descending("__time"));

    public static boolean preferDescendingTimeOrdering(CursorBuildSpec buildSpec) {
        List<OrderBy> preferredOrdering = buildSpec.getPreferredOrdering();
        if (preferredOrdering != null && !preferredOrdering.isEmpty()) {
            OrderBy orderBy = preferredOrdering.get(0);
            return "__time".equals(orderBy.getColumnName()) && Order.DESCENDING == orderBy.getOrder();
        }
        return false;
    }

    public static Order getTimeOrdering(List<OrderBy> ordering) {
        if (!ordering.isEmpty() && "__time".equals(ordering.get(0).getColumnName())) {
            return ordering.get(0).getOrder();
        }
        return Order.NONE;
    }

    public static List<OrderBy> ascendingTimeOrder() {
        return TIME_ASCENDING_ORDER;
    }

    public static List<OrderBy> descendingTimeOrder() {
        return TIME_DESCENDING_ORDER;
    }
}

