/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.metrics.cgroups;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.metrics.cgroups.CgroupDiscoverer;
import org.apache.druid.java.util.metrics.cgroups.CpuSet;

public class CpuSetV2 {
    private static final Logger LOG = new Logger(CpuSetV2.class);
    public static final String CGROUP = "";
    private static final String CPUS_FILE = "cpuset.cpus";
    private static final String EFFECTIVE_CPUS_FILE = "cpuset.cpus.effective";
    private static final String MEMS_FILE = "cpuset.mems";
    private static final String EFFECTIVE_MEMS_FILE = "cpuset.mems.effective";
    private final CgroupDiscoverer cgroupDiscoverer;

    public CpuSetV2(CgroupDiscoverer cgroupDiscoverer) {
        this.cgroupDiscoverer = cgroupDiscoverer;
    }

    public CpuSet.CpuSetMetric snapshot() {
        return new CpuSet.CpuSetMetric(this.readCpuSetFile(CPUS_FILE), this.readCpuSetFile(EFFECTIVE_CPUS_FILE), this.readCpuSetFile(MEMS_FILE), this.readCpuSetFile(EFFECTIVE_MEMS_FILE));
    }

    private int[] readCpuSetFile(String file) {
        int[] output = new int[]{};
        try {
            List<String> lines = Files.readAllLines(Paths.get(this.cgroupDiscoverer.discover(CGROUP).toString(), file));
            output = lines.stream().map(CpuSet::parseStringRangeToIntArray).findFirst().orElse(output);
        }
        catch (IOException | RuntimeException ex) {
            LOG.noStackTrace().warn(ex, "Unable to read %s, these metrics will be skipped", file);
        }
        return output;
    }
}

