/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.metrics;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.java.util.metrics.FeedDefiningMonitor;

public class JvmThreadsMonitor
extends FeedDefiningMonitor {
    private int lastLiveThreads = 0;
    private long lastStartedThreads = 0L;

    public JvmThreadsMonitor() {
        this("metrics");
    }

    public JvmThreadsMonitor(String feed) {
        super(feed);
    }

    @Override
    public boolean doMonitor(ServiceEmitter emitter) {
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        ServiceMetricEvent.Builder builder = this.builder();
        int newLiveThreads = threadBean.getThreadCount();
        long newStartedThreads = threadBean.getTotalStartedThreadCount();
        long startedThreadsDiff = newStartedThreads - this.lastStartedThreads;
        emitter.emit(builder.setMetric("jvm/threads/started", startedThreadsDiff));
        emitter.emit(builder.setMetric("jvm/threads/finished", (long)this.lastLiveThreads + startedThreadsDiff - (long)newLiveThreads));
        emitter.emit(builder.setMetric("jvm/threads/live", newLiveThreads));
        emitter.emit(builder.setMetric("jvm/threads/liveDaemon", threadBean.getDaemonThreadCount()));
        emitter.emit(builder.setMetric("jvm/threads/livePeak", threadBean.getPeakThreadCount()));
        threadBean.resetPeakThreadCount();
        this.lastStartedThreads = newStartedThreads;
        this.lastLiveThreads = newLiveThreads;
        return true;
    }
}

