/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.processor.manager;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Optional;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.frame.processor.Bouncer;
import org.apache.druid.frame.processor.manager.ProcessorAndCallback;
import org.apache.druid.frame.processor.manager.ProcessorManager;

public class ConcurrencyLimitedProcessorManager<T, R>
implements ProcessorManager<T, R> {
    private final ProcessorManager<T, R> delegate;
    private final Bouncer bouncer;

    public ConcurrencyLimitedProcessorManager(ProcessorManager<T, R> delegate, int limit) {
        this.delegate = delegate;
        this.bouncer = new Bouncer(limit);
    }

    @Override
    public ListenableFuture<Optional<ProcessorAndCallback<T>>> next() {
        ListenableFuture<Bouncer.Ticket> ticket = this.bouncer.ticket();
        return FutureUtils.transformAsync(ticket, t -> FutureUtils.transform(this.delegate.next(), nextProcessor -> nextProcessor.map(retVal -> new ProcessorAndCallback<Object>(retVal.processor(), r -> {
            ((Bouncer.Ticket)FutureUtils.getUncheckedImmediately(ticket)).giveBack();
            retVal.onComplete(r);
        }))));
    }

    @Override
    public R result() {
        return this.delegate.result();
    }

    @Override
    public void close() {
        this.delegate.close();
    }
}

