/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline;

import com.google.common.collect.Iterators;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.VersionedIntervalTimeline;

public class SegmentTimeline
extends VersionedIntervalTimeline<String, DataSegment> {
    public static SegmentTimeline forSegments(Iterable<DataSegment> segments) {
        return SegmentTimeline.forSegments(segments.iterator());
    }

    public static SegmentTimeline forSegments(Iterator<DataSegment> segments) {
        SegmentTimeline timeline = new SegmentTimeline();
        timeline.addSegments(segments);
        return timeline;
    }

    public SegmentTimeline() {
        super(Comparator.naturalOrder());
    }

    public void addSegments(Iterator<DataSegment> segments) {
        this.addAll(Iterators.transform(segments, segment -> new VersionedIntervalTimeline.PartitionChunkEntry<String, DataSegment>(segment.getInterval(), segment.getVersion(), segment.getShardSpec().createChunk(segment))));
    }

    public void add(DataSegment segment) {
        this.add(segment.getInterval(), segment.getVersion(), segment.getShardSpec().createChunk(segment));
    }

    public void remove(DataSegment segment) {
        this.remove(segment.getInterval(), segment.getVersion(), segment.getShardSpec().createChunk(segment));
    }

    public boolean isOvershadowed(DataSegment segment) {
        return this.isOvershadowed(segment.getInterval(), segment.getVersion(), segment);
    }
}

