/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.writeout;

import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.apache.druid.io.Channels;
import org.apache.druid.java.util.common.ByteBufferUtils;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.IOE;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.segment.writeout.WriteOutBytes;

public final class FileWriteOutBytes
extends WriteOutBytes {
    private final File file;
    private final FileChannel ch;
    private long writeOutBytes;
    private final ByteBuffer buffer = ByteBuffer.allocateDirect(32768);

    FileWriteOutBytes(File file, FileChannel ch, Closer closer) {
        this.file = file;
        this.ch = ch;
        this.writeOutBytes = 0L;
        closer.register(() -> ByteBufferUtils.free(this.buffer));
    }

    private void flushIfNeeded(int bytesNeeded) throws IOException {
        if (this.buffer.remaining() < bytesNeeded) {
            this.flush();
        }
    }

    @Override
    public void flush() throws IOException {
        this.buffer.flip();
        try {
            Channels.writeFully(this.ch, this.buffer);
        }
        catch (IOException e) {
            throw new IOE(e, "Failed to write to file: %s. Current size of file: %d", this.file.getAbsolutePath(), this.writeOutBytes);
        }
        this.buffer.clear();
    }

    @Override
    public void write(int b) throws IOException {
        this.flushIfNeeded(1);
        this.buffer.put((byte)b);
        ++this.writeOutBytes;
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.flushIfNeeded(4);
        this.buffer.putInt(v);
        this.writeOutBytes += 4L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer src) throws IOException {
        int len = src.remaining();
        this.flushIfNeeded(len);
        if (len > this.buffer.remaining()) {
            Channels.writeFully(this.ch, src);
            this.writeOutBytes += (long)len;
        } else {
            while (src.remaining() > this.buffer.capacity()) {
                int srcLimit = src.limit();
                try {
                    src.limit(src.position() + this.buffer.capacity());
                    this.buffer.put(src);
                    this.writeOutBytes += (long)this.buffer.capacity();
                    this.flush();
                }
                finally {
                    src.limit(srcLimit);
                }
            }
            int remaining = src.remaining();
            this.buffer.put(src);
            this.writeOutBytes += (long)remaining;
        }
        return len;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.write(ByteBuffer.wrap(b, off, len));
    }

    @Override
    public long size() {
        return this.writeOutBytes;
    }

    @Override
    public void writeTo(WritableByteChannel channel) throws IOException {
        this.flush();
        this.ch.position(0L);
        try {
            ByteStreams.copy((ReadableByteChannel)this.ch, (WritableByteChannel)channel);
        }
        finally {
            this.ch.position(this.ch.size());
        }
    }

    @Override
    public void readFully(long pos, ByteBuffer buffer) throws IOException {
        if (pos < 0L || pos > this.writeOutBytes) {
            throw new IAE("pos %d out of range [%d, %d]", pos, 0, this.writeOutBytes);
        }
        this.flush();
        this.ch.read(buffer, pos);
        if (buffer.remaining() > 0) {
            throw new BufferUnderflowException();
        }
    }

    @Override
    public InputStream asInputStream() throws IOException {
        this.flush();
        return new FileInputStream(this.file);
    }

    @Override
    public boolean isOpen() {
        return this.ch.isOpen();
    }
}

