/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.virtual;

import javax.annotation.Nullable;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.BaseSingleValueDimensionSelector;
import org.apache.druid.segment.ColumnValueSelector;

class ExpressionSingleValueDimensionSelector
extends BaseSingleValueDimensionSelector {
    protected final ColumnValueSelector<ExprEval> baseSelector;

    public static ExpressionSingleValueDimensionSelector fromValueSelector(ColumnValueSelector<ExprEval> baseSelector, @Nullable ExtractionFn extractionFn) {
        if (extractionFn != null) {
            return new ExtractionExpressionDimensionSelector(baseSelector, extractionFn);
        }
        return new ExpressionSingleValueDimensionSelector(baseSelector);
    }

    ExpressionSingleValueDimensionSelector(ColumnValueSelector<ExprEval> baseSelector) {
        this.baseSelector = baseSelector;
    }

    @Override
    protected String getValue() {
        return ((ExprEval)this.baseSelector.getObject()).asString();
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("baseSelector", this.baseSelector);
    }

    static class ExtractionExpressionDimensionSelector
    extends ExpressionSingleValueDimensionSelector {
        private final ExtractionFn extractionFn;

        ExtractionExpressionDimensionSelector(ColumnValueSelector<ExprEval> baseSelector, ExtractionFn extractionFn) {
            super(baseSelector);
            this.extractionFn = extractionFn;
        }

        @Override
        protected String getValue() {
            return this.extractionFn.apply(((ExprEval)this.baseSelector.getObject()).asString());
        }

        @Override
        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            inspector.visit("baseSelector", this.baseSelector);
            inspector.visit("extractionFn", this.extractionFn);
        }
    }
}

