/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.incremental;

import java.util.Map;
import org.apache.druid.segment.incremental.RowIngestionMeters;
import org.apache.druid.segment.incremental.RowIngestionMetersTotals;

public class SimpleRowIngestionMeters
implements RowIngestionMeters {
    private long processed;
    private long processedWithError;
    private long unparseable;
    private long thrownAway;
    private long processedBytes;

    @Override
    public long getProcessed() {
        return this.processed;
    }

    @Override
    public void incrementProcessed() {
        ++this.processed;
    }

    @Override
    public void incrementProcessedBytes(long increment) {
        this.processedBytes += increment;
    }

    @Override
    public long getProcessedBytes() {
        return this.processedBytes;
    }

    @Override
    public long getProcessedWithError() {
        return this.processedWithError;
    }

    @Override
    public void incrementProcessedWithError() {
        ++this.processedWithError;
    }

    @Override
    public long getUnparseable() {
        return this.unparseable;
    }

    @Override
    public void incrementUnparseable() {
        ++this.unparseable;
    }

    @Override
    public long getThrownAway() {
        return this.thrownAway;
    }

    @Override
    public void incrementThrownAway() {
        ++this.thrownAway;
    }

    @Override
    public RowIngestionMetersTotals getTotals() {
        return new RowIngestionMetersTotals(this.processed, this.processedBytes, this.processedWithError, this.thrownAway, this.unparseable);
    }

    @Override
    public Map<String, Object> getMovingAverages() {
        throw new UnsupportedOperationException();
    }

    public void addRowIngestionMetersTotals(RowIngestionMetersTotals rowIngestionMetersTotals) {
        this.processed += rowIngestionMetersTotals.getProcessed();
        this.processedWithError += rowIngestionMetersTotals.getProcessedWithError();
        this.unparseable += rowIngestionMetersTotals.getUnparseable();
        this.thrownAway += rowIngestionMetersTotals.getThrownAway();
        this.processedBytes += rowIngestionMetersTotals.getProcessedBytes();
    }
}

