/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.BitmapResultFactory;
import org.apache.druid.query.filter.BooleanUnaryFilter;
import org.apache.druid.query.filter.ColumnIndexSelector;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.FilterBundle;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.filter.vector.BaseVectorValueMatcher;
import org.apache.druid.query.filter.vector.ReadableVectorMatch;
import org.apache.druid.query.filter.vector.VectorMatch;
import org.apache.druid.query.filter.vector.VectorValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.column.ColumnIndexCapabilities;
import org.apache.druid.segment.index.BitmapColumnIndex;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;

public class NotFilter
implements BooleanUnaryFilter {
    private final Filter baseFilter;

    public NotFilter(Filter baseFilter) {
        this.baseFilter = baseFilter;
    }

    @Override
    @Nullable
    public BitmapColumnIndex getBitmapColumnIndex(int numRows, FilterBundle.Builder baseBuilder) {
        return NotFilter.getBitmapColumnIndex(numRows, baseBuilder.getBitmapColumnIndex());
    }

    @Override
    @Nullable
    public BitmapColumnIndex getBitmapColumnIndex(ColumnIndexSelector selector) {
        return NotFilter.getBitmapColumnIndex(selector.getNumRows(), this.baseFilter.getBitmapColumnIndex(selector));
    }

    @Override
    public ValueMatcher makeMatcher(ColumnSelectorFactory factory) {
        final ValueMatcher baseMatcher = this.baseFilter.makeMatcher(factory);
        return new ValueMatcher(){

            @Override
            public boolean matches(boolean includeUnknown) {
                return !baseMatcher.matches(!includeUnknown);
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("baseMatcher", baseMatcher);
            }
        };
    }

    @Override
    public VectorValueMatcher makeVectorMatcher(final VectorColumnSelectorFactory factory) {
        final VectorValueMatcher baseMatcher = this.baseFilter.makeVectorMatcher(factory);
        return new BaseVectorValueMatcher(baseMatcher){
            private final VectorMatch scratch;
            {
                super(selector);
                this.scratch = VectorMatch.wrap(new int[factory.getMaxVectorSize()]);
            }

            @Override
            public ReadableVectorMatch match(ReadableVectorMatch mask, boolean includeUnknown) {
                ReadableVectorMatch baseMatch = baseMatcher.match(mask, !includeUnknown);
                this.scratch.copyFrom(mask);
                this.scratch.removeAll(baseMatch);
                assert (this.scratch.isValid(mask));
                return this.scratch;
            }
        };
    }

    @Override
    public boolean canVectorizeMatcher(ColumnInspector inspector) {
        return this.baseFilter.canVectorizeMatcher(inspector);
    }

    @Override
    public Set<String> getRequiredColumns() {
        return this.baseFilter.getRequiredColumns();
    }

    @Override
    public boolean supportsRequiredColumnRewrite() {
        return this.baseFilter.supportsRequiredColumnRewrite();
    }

    @Override
    public Filter rewriteRequiredColumns(Map<String, String> columnRewrites) {
        return new NotFilter(this.baseFilter.rewriteRequiredColumns(columnRewrites));
    }

    public String toString() {
        return StringUtils.format("~(%s)", this.baseFilter);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotFilter notFilter = (NotFilter)o;
        return Objects.equals(this.baseFilter, notFilter.baseFilter);
    }

    public int hashCode() {
        return Objects.hash(1, this.baseFilter);
    }

    @Override
    public Filter getBaseFilter() {
        return this.baseFilter;
    }

    @Nullable
    private static BitmapColumnIndex getBitmapColumnIndex(final int numRows, final BitmapColumnIndex baseIndex) {
        if (baseIndex != null && baseIndex.getIndexCapabilities().isInvertible()) {
            return new BitmapColumnIndex(){

                @Override
                public ColumnIndexCapabilities getIndexCapabilities() {
                    return baseIndex.getIndexCapabilities();
                }

                @Override
                public int estimatedComputeCost() {
                    return 0;
                }

                @Override
                public <T> T computeBitmapResult(BitmapResultFactory<T> bitmapResultFactory, boolean includeUnknown) {
                    return bitmapResultFactory.complement(baseIndex.computeBitmapResult(bitmapResultFactory, !includeUnknown), numRows);
                }

                @Override
                @Nullable
                public <T> T computeBitmapResult(BitmapResultFactory<T> bitmapResultFactory, int applyRowCount, int totalRowCount, boolean includeUnknown) {
                    T result = baseIndex.computeBitmapResult(bitmapResultFactory, applyRowCount, totalRowCount, !includeUnknown);
                    if (result == null) {
                        return null;
                    }
                    return bitmapResultFactory.complement(result, numRows);
                }
            };
        }
        return null;
    }
}

