/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.column;

import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.column.LongsColumnWithNulls;
import org.apache.druid.segment.column.NumericColumn;
import org.apache.druid.segment.data.ColumnarLongs;
import org.apache.druid.segment.data.ReadableOffset;
import org.apache.druid.segment.vector.ReadableVectorOffset;
import org.apache.druid.segment.vector.VectorValueSelector;

public class LongsColumn
implements NumericColumn {
    final ColumnarLongs column;

    public static LongsColumn create(ColumnarLongs column, ImmutableBitmap nullValueBitmap) {
        if (nullValueBitmap.isEmpty()) {
            return new LongsColumn(column);
        }
        return new LongsColumnWithNulls(column, nullValueBitmap);
    }

    LongsColumn(ColumnarLongs column) {
        this.column = column;
    }

    @Override
    public int length() {
        return this.column.size();
    }

    @Override
    public ColumnValueSelector<?> makeColumnValueSelector(ReadableOffset offset) {
        return this.column.makeColumnValueSelector(offset, IndexIO.LEGACY_FACTORY.getBitmapFactory().makeEmptyImmutableBitmap());
    }

    @Override
    public VectorValueSelector makeVectorValueSelector(ReadableVectorOffset offset) {
        return this.column.makeVectorValueSelector(offset, IndexIO.LEGACY_FACTORY.getBitmapFactory().makeEmptyImmutableBitmap());
    }

    @Override
    public long getLongSingleValueRow(int rowNum) {
        return this.column.get(rowNum);
    }

    @Override
    @Nullable
    public <T> T as(Class<T> clazz) {
        return this.column.as(clazz);
    }

    @Override
    public void close() {
        this.column.close();
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("column", this.column);
    }
}

