/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.rowsandcols.column;

import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.NotYetImplemented;
import org.apache.druid.query.rowsandcols.column.BinarySearchableAccessor;
import org.apache.druid.query.rowsandcols.column.Column;
import org.apache.druid.query.rowsandcols.column.ColumnAccessor;
import org.apache.druid.query.rowsandcols.column.ColumnValueSwapper;
import org.apache.druid.query.rowsandcols.column.VectorCopier;
import org.apache.druid.query.rowsandcols.util.FindResult;
import org.apache.druid.segment.column.ColumnType;

public class IntArrayColumn
implements Column {
    private final int[] vals;

    public IntArrayColumn(int[] vals) {
        this.vals = vals;
    }

    @Override
    @Nonnull
    public ColumnAccessor toAccessor() {
        return new MyColumnAccessor();
    }

    @Override
    @Nullable
    public <T> T as(Class<? extends T> clazz) {
        if (VectorCopier.class.equals(clazz)) {
            return (T)((VectorCopier)(into, intoStart) -> {
                if (Integer.MAX_VALUE - this.vals.length < intoStart) {
                    throw DruidException.forPersona(DruidException.Persona.USER).ofCategory(DruidException.Category.CAPACITY_EXCEEDED).build("too many rows!!! intoStart[%,d], vals.length[%,d] combine to exceed max_int", intoStart, this.vals.length);
                }
                for (int i = 0; i < this.vals.length; ++i) {
                    into[intoStart + i] = this.vals[i];
                }
            });
        }
        if (ColumnValueSwapper.class.equals(clazz)) {
            return (T)((ColumnValueSwapper)(lhs, rhs) -> {
                int tmp = this.vals[lhs];
                this.vals[lhs] = this.vals[rhs];
                this.vals[rhs] = tmp;
            });
        }
        return null;
    }

    private class MyColumnAccessor
    implements BinarySearchableAccessor {
        private MyColumnAccessor() {
        }

        @Override
        public ColumnType getType() {
            return ColumnType.LONG;
        }

        @Override
        public int numRows() {
            return IntArrayColumn.this.vals.length;
        }

        @Override
        public boolean isNull(int rowNum) {
            return false;
        }

        @Override
        public Object getObject(int rowNum) {
            return IntArrayColumn.this.vals[rowNum];
        }

        @Override
        public double getDouble(int rowNum) {
            return IntArrayColumn.this.vals[rowNum];
        }

        @Override
        public float getFloat(int rowNum) {
            return IntArrayColumn.this.vals[rowNum];
        }

        @Override
        public long getLong(int rowNum) {
            return IntArrayColumn.this.vals[rowNum];
        }

        @Override
        public int getInt(int rowNum) {
            return IntArrayColumn.this.vals[rowNum];
        }

        @Override
        public int compareRows(int lhsRowNum, int rhsRowNum) {
            return Integer.compare(IntArrayColumn.this.vals[lhsRowNum], IntArrayColumn.this.vals[rhsRowNum]);
        }

        @Override
        public FindResult findNull(int startIndex, int endIndex) {
            return FindResult.notFound(endIndex);
        }

        @Override
        public FindResult findDouble(int startIndex, int endIndex, double val) {
            return this.findInt(startIndex, endIndex, (int)val);
        }

        @Override
        public FindResult findFloat(int startIndex, int endIndex, float val) {
            return this.findInt(startIndex, endIndex, (int)val);
        }

        @Override
        public FindResult findLong(int startIndex, int endIndex, long val) {
            return this.findInt(startIndex, endIndex, (int)val);
        }

        public FindResult findInt(int startIndex, int endIndex, int val) {
            if (IntArrayColumn.this.vals[startIndex] == val) {
                int end;
                for (end = startIndex + 1; end < endIndex && IntArrayColumn.this.vals[end] == val; ++end) {
                }
                return FindResult.found(startIndex, end);
            }
            int i = Arrays.binarySearch(IntArrayColumn.this.vals, startIndex, endIndex, val);
            if (i > 0) {
                int foundStart = i;
                int foundEnd = i + 1;
                while (foundStart - 1 >= startIndex && IntArrayColumn.this.vals[foundStart - 1] == val) {
                    --foundStart;
                }
                while (foundEnd < endIndex && IntArrayColumn.this.vals[foundEnd] == val) {
                    ++foundEnd;
                }
                return FindResult.found(foundStart, foundEnd);
            }
            return FindResult.notFound(-(i + 1));
        }

        @Override
        public FindResult findString(int startIndex, int endIndex, String val) {
            throw NotYetImplemented.ex(null, "findString is not currently supported for IntArrayColumns", new Object[0]);
        }

        @Override
        public FindResult findComplex(int startIndex, int endIndex, Object val) {
            throw NotYetImplemented.ex(null, "findComplex is not currently supported for IntArrayColumns", new Object[0]);
        }
    }
}

