/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter;

import java.lang.invoke.LambdaMetafactory;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.druid.annotations.SubclassesMustOverrideEqualsAndHashCode;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.query.BitmapResultFactory;
import org.apache.druid.query.filter.ColumnIndexSelector;
import org.apache.druid.query.filter.FilterBundle;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.filter.vector.VectorValueMatcher;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.index.BitmapColumnIndex;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;

@SubclassesMustOverrideEqualsAndHashCode
public interface Filter {
    default public <T> FilterBundle makeFilterBundle(FilterBundle.Builder filterBundleBuilder, BitmapResultFactory<T> bitmapResultFactory, int applyRowCount, int totalRowCount, boolean includeUnknown) {
        boolean needMatcher;
        FilterBundle.SimpleIndexBundle indexBundle;
        BitmapColumnIndex columnIndex = filterBundleBuilder.getBitmapColumnIndex();
        if (columnIndex != null) {
            long bitmapConstructionStartNs = System.nanoTime();
            T result = columnIndex.computeBitmapResult(bitmapResultFactory, applyRowCount, totalRowCount, includeUnknown);
            long totalConstructionTimeNs = System.nanoTime() - bitmapConstructionStartNs;
            if (result == null) {
                indexBundle = null;
            } else {
                ImmutableBitmap bitmap = bitmapResultFactory.toImmutableBitmap(result);
                indexBundle = new FilterBundle.SimpleIndexBundle(new FilterBundle.IndexBundleInfo((Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, toString(), ()Ljava/lang/String;)((Filter)this), bitmap.size(), totalConstructionTimeNs, null), bitmap, columnIndex.getIndexCapabilities());
            }
            needMatcher = result == null || !columnIndex.getIndexCapabilities().isExact();
        } else {
            indexBundle = null;
            needMatcher = true;
        }
        FilterBundle.SimpleMatcherBundle matcherBundle = needMatcher ? new FilterBundle.SimpleMatcherBundle(new FilterBundle.MatcherBundleInfo((Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, toString(), ()Ljava/lang/String;)((Filter)this), null, null), this::makeMatcher, this::makeVectorMatcher, this.canVectorizeMatcher(filterBundleBuilder.getColumnIndexSelector())) : null;
        return new FilterBundle(indexBundle, matcherBundle);
    }

    @Nullable
    public BitmapColumnIndex getBitmapColumnIndex(ColumnIndexSelector var1);

    public ValueMatcher makeMatcher(ColumnSelectorFactory var1);

    default public VectorValueMatcher makeVectorMatcher(VectorColumnSelectorFactory factory) {
        throw new UOE("Filter[%s] cannot vectorize", this.getClass().getName());
    }

    default public boolean canVectorizeMatcher(ColumnInspector inspector) {
        return false;
    }

    public Set<String> getRequiredColumns();

    default public boolean supportsRequiredColumnRewrite() {
        return false;
    }

    default public Filter rewriteRequiredColumns(Map<String, String> columnRewrites) {
        throw new UnsupportedOperationException("Required column rewrite is not supported by this filter.");
    }
}

