/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.hyperloglog;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.druid.hll.HyperLogLogCollector;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.query.aggregation.hyperloglog.HyperUniquesBufferAggregator;
import org.apache.druid.segment.vector.VectorObjectSelector;

public class HyperUniquesVectorAggregator
implements VectorAggregator {
    private final VectorObjectSelector selector;

    public HyperUniquesVectorAggregator(VectorObjectSelector selector) {
        this.selector = (VectorObjectSelector)Preconditions.checkNotNull((Object)selector, (Object)"selector");
    }

    @Override
    public void init(ByteBuffer buf, int position) {
        HyperUniquesBufferAggregator.doInit(buf, position);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void aggregate(ByteBuffer buf, int position, int startRow, int endRow) {
        int oldPosition = buf.position();
        int oldLimit = buf.limit();
        buf.limit(position + HyperLogLogCollector.getLatestNumBytesForDenseStorage());
        buf.position(position);
        try {
            HyperLogLogCollector collector = HyperLogLogCollector.makeCollector(buf);
            Object[] vector = this.selector.getObjectVector();
            for (int i = startRow; i < endRow; ++i) {
                HyperLogLogCollector otherCollector = (HyperLogLogCollector)vector[i];
                if (otherCollector == null) continue;
                collector.fold(otherCollector);
            }
        }
        finally {
            buf.limit(oldLimit);
            buf.position(oldPosition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void aggregate(ByteBuffer buf, int numRows, int[] positions, @Nullable int[] rows, int positionOffset) {
        Object[] vector = this.selector.getObjectVector();
        for (int i = 0; i < numRows; ++i) {
            HyperLogLogCollector otherCollector = (HyperLogLogCollector)vector[rows != null ? rows[i] : i];
            if (otherCollector == null) continue;
            int position = positions[i] + positionOffset;
            int oldPosition = buf.position();
            int oldLimit = buf.limit();
            buf.limit(position + HyperLogLogCollector.getLatestNumBytesForDenseStorage());
            buf.position(position);
            try {
                HyperLogLogCollector.makeCollector(buf).fold(otherCollector);
                continue;
            }
            finally {
                buf.limit(oldLimit);
                buf.position(oldPosition);
            }
        }
    }

    @Override
    public Object get(ByteBuffer buf, int position) {
        return HyperUniquesBufferAggregator.doGet(buf, position);
    }

    @Override
    public void close() {
    }
}

