/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.collections.SerializablePair;
import org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.druid.query.aggregation.AbstractSerializablePairLongObjectColumnHeader;
import org.apache.druid.query.aggregation.AbstractSerializablePairLongObjectDeltaEncodedStagedSerde;
import org.apache.druid.query.aggregation.SerializedStorage;
import org.apache.druid.segment.serde.Serializer;
import org.apache.druid.segment.serde.cell.ByteBufferProvider;
import org.apache.druid.segment.serde.cell.CellWriter;
import org.apache.druid.segment.serde.cell.IOIterator;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;

public abstract class AbstractSerializablePairLongObjectBufferStore<T extends SerializablePair<Long, ?>> {
    private final SerializedStorage<T> serializedStorage;
    long minValue = Long.MAX_VALUE;
    long maxValue = Long.MIN_VALUE;

    AbstractSerializablePairLongObjectBufferStore(SerializedStorage<T> serializedStorage) {
        this.serializedStorage = serializedStorage;
    }

    public void store(@Nullable T pairLongObject) throws IOException {
        if (pairLongObject != null && ((SerializablePair)pairLongObject).lhs != null) {
            this.minValue = Math.min(this.minValue, (Long)((SerializablePair)pairLongObject).lhs);
            this.maxValue = Math.max(this.maxValue, (Long)((SerializablePair)pairLongObject).lhs);
        }
        this.serializedStorage.store(pairLongObject);
    }

    public TransferredBuffer transferToRowWriter(ByteBufferProvider byteBufferProvider, SegmentWriteOutMedium segmentWriteOutMedium) throws IOException {
        AbstractSerializablePairLongObjectColumnHeader<T> columnHeader = this.createColumnHeader();
        AbstractSerializablePairLongObjectDeltaEncodedStagedSerde<SerializablePair> deltaEncodedSerde = this.createDeltaEncodedSerde(columnHeader);
        try (CellWriter cellWriter = new CellWriter.Builder(segmentWriteOutMedium).setByteBufferProvider(byteBufferProvider).build();){
            IOIterator<T> bufferIterator = this.iterator();
            try {
                while (bufferIterator.hasNext()) {
                    SerializablePair pairLongObject = (SerializablePair)bufferIterator.next();
                    byte[] serialized = deltaEncodedSerde.serialize(pairLongObject);
                    cellWriter.write(serialized);
                }
                cellWriter.close();
                TransferredBuffer transferredBuffer = new TransferredBuffer(cellWriter, columnHeader);
                if (bufferIterator != null) {
                    bufferIterator.close();
                }
                return transferredBuffer;
            }
            catch (Throwable throwable) {
                if (bufferIterator != null) {
                    try {
                        bufferIterator.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }

    @Nonnull
    public abstract AbstractSerializablePairLongObjectColumnHeader<T> createColumnHeader();

    public abstract AbstractSerializablePairLongObjectDeltaEncodedStagedSerde<T> createDeltaEncodedSerde(AbstractSerializablePairLongObjectColumnHeader<T> var1);

    public IOIterator<T> iterator() throws IOException {
        return this.serializedStorage.iterator();
    }

    public static class TransferredBuffer
    implements Serializer {
        private final CellWriter cellWriter;
        private final AbstractSerializablePairLongObjectColumnHeader<?> columnHeader;

        public TransferredBuffer(CellWriter cellWriter, AbstractSerializablePairLongObjectColumnHeader<?> columnHeader) {
            this.cellWriter = cellWriter;
            this.columnHeader = columnHeader;
        }

        @Override
        public long getSerializedSize() {
            return (long)this.columnHeader.getSerializedSize() + this.cellWriter.getSerializedSize();
        }

        @Override
        public void writeTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
            this.columnHeader.transferTo(channel);
            this.cellWriter.writeTo(channel, smoosher);
        }
    }
}

