/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr.vector;

import java.util.Arrays;
import javax.annotation.Nullable;
import org.apache.druid.math.expr.Evals;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.vector.BaseExprEvalVector;

public final class ExprEvalLongVector
extends BaseExprEvalVector<long[]> {
    public ExprEvalLongVector(long[] values, @Nullable boolean[] nulls) {
        super(values, nulls);
    }

    @Override
    public ExpressionType getType() {
        return ExpressionType.LONG;
    }

    @Override
    public long[] getLongVector() {
        return (long[])this.values;
    }

    @Override
    public double[] getDoubleVector() {
        return Arrays.stream((long[])this.values).asDoubleStream().toArray();
    }

    @Override
    public Object[] getObjectVector() {
        Object[] objects = new Long[((long[])this.values).length];
        if (this.nulls != null) {
            for (int i = 0; i < ((long[])this.values).length; ++i) {
                objects[i] = this.nulls[i] ? null : Long.valueOf(((long[])this.values)[i]);
            }
        } else {
            for (int i = 0; i < ((long[])this.values).length; ++i) {
                objects[i] = ((long[])this.values)[i];
            }
        }
        return objects;
    }

    @Override
    public boolean elementAsBoolean(int index) {
        if (this.nulls != null && this.nulls[index]) {
            return false;
        }
        return Evals.asBoolean(((long[])this.values)[index]);
    }
}

