/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.emitter.core;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.emitter.core.Event;
import org.apache.druid.java.util.emitter.core.EventMap;
import org.apache.druid.java.util.emitter.core.UriExtractor;

public class ParametrizedUriExtractor
implements UriExtractor {
    private String uriPattern;
    private Set<String> params;

    public ParametrizedUriExtractor(String uriPattern) {
        this.uriPattern = uriPattern;
        Matcher keyMatcher = Pattern.compile("\\{([^}]+)}").matcher(uriPattern);
        this.params = new HashSet<String>();
        while (keyMatcher.find()) {
            this.params.add(keyMatcher.group(1));
        }
    }

    public Set<String> getParams() {
        return this.params;
    }

    @Override
    public URI apply(Event event) throws URISyntaxException {
        EventMap eventMap = event.toMap();
        String processedUri = this.uriPattern;
        for (String key : this.params) {
            Object paramValue = eventMap.get(key);
            if (paramValue == null) {
                throw new IAE("ParametrizedUriExtractor with pattern %s requires %s to be set in event, but found %s", this.uriPattern, key, eventMap);
            }
            processedUri = StringUtils.replace(processedUri, StringUtils.format("{%s}", key), paramValue.toString());
        }
        return new URI(processedUri);
    }

    public String toString() {
        return "ParametrizedUriExtractor{uriPattern='" + this.uriPattern + "', params=" + String.valueOf(this.params) + "}";
    }
}

