/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.processor;

import com.google.common.util.concurrent.ListenableFuture;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.util.Collection;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;

public class ReturnOrAwait<T> {
    private static final IntSet RANGE_SET_ONE = IntSets.singleton((int)0);
    @Nullable
    private final T retVal;
    @Nullable
    private final IntSet awaitChannels;
    private final boolean awaitAllChannels;
    @Nullable
    private final Collection<ListenableFuture<?>> awaitFutures;

    private ReturnOrAwait(@Nullable T retVal, @Nullable IntSet awaitChannels, @Nullable Collection<ListenableFuture<?>> awaitFutures, boolean awaitAllChannels) {
        this.retVal = retVal;
        this.awaitChannels = awaitChannels;
        this.awaitAllChannels = awaitAllChannels;
        this.awaitFutures = awaitFutures;
        if (retVal != null && (awaitChannels != null || awaitFutures != null)) {
            throw new IAE("Cannot have a value when await != null or futures != null", new Object[0]);
        }
        if (awaitChannels != null && awaitFutures != null) {
            throw new ISE("Cannot have both awaitChannels and awaitFutures", new Object[0]);
        }
    }

    public static <T> ReturnOrAwait<T> runAgain() {
        return new ReturnOrAwait<Object>(null, IntSets.emptySet(), null, true);
    }

    public static <T> ReturnOrAwait<T> awaitAll(IntSet await) {
        return new ReturnOrAwait<Object>(null, await, null, true);
    }

    public static <T> ReturnOrAwait<T> awaitAll(int count) {
        return new ReturnOrAwait<Object>(null, ReturnOrAwait.rangeSet(count), null, true);
    }

    public static <T> ReturnOrAwait<T> awaitAllFutures(Collection<ListenableFuture<?>> futures) {
        return new ReturnOrAwait<Object>(null, null, futures, true);
    }

    public static <T> ReturnOrAwait<T> awaitAny(IntSet await) {
        return new ReturnOrAwait<Object>(null, await, null, false);
    }

    public static <T> ReturnOrAwait<T> returnObject(T o) {
        return new ReturnOrAwait<T>(o, null, null, false);
    }

    @Nullable
    public T value() {
        if (this.isAwait()) {
            throw new ISE("No value yet", new Object[0]);
        }
        return this.retVal;
    }

    public IntSet awaitableChannels() {
        if (!this.hasAwaitableChannels()) {
            throw new ISE("No await set", new Object[0]);
        }
        return this.awaitChannels;
    }

    public Collection<ListenableFuture<?>> awaitableFutures() {
        if (!this.hasAwaitableFutures()) {
            throw new ISE("No futures set", new Object[0]);
        }
        return this.awaitFutures;
    }

    public boolean isReturn() {
        return this.awaitChannels == null && this.awaitFutures == null;
    }

    public boolean isAwait() {
        return !this.isReturn();
    }

    public boolean hasAwaitableFutures() {
        return this.awaitFutures != null;
    }

    public boolean hasAwaitableChannels() {
        return this.awaitChannels != null;
    }

    public boolean isAwaitAllChannels() {
        if (!this.hasAwaitableChannels()) {
            throw new ISE("No channels set", new Object[0]);
        }
        return this.awaitAllChannels;
    }

    public String toString() {
        if (this.hasAwaitableChannels()) {
            return "await channels=" + (this.awaitAllChannels ? "all" : "any") + String.valueOf(this.awaitChannels);
        }
        if (this.hasAwaitableFutures()) {
            return "await futures=" + String.valueOf(this.awaitFutures);
        }
        return "return=" + String.valueOf(this.retVal);
    }

    private static IntSet rangeSet(int count) {
        if (count == 0) {
            return IntSets.emptySet();
        }
        if (count == 1) {
            return RANGE_SET_ONE;
        }
        return IntSets.fromTo((int)0, (int)count);
    }
}

