/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.file;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.ISE;

public class FrameFilePartialFetch {
    private final boolean lastFetchHeaderSet;
    private long bytesRead;
    @Nullable
    private Throwable exceptionCaught;
    @Nullable
    private ListenableFuture<?> backpressureFuture;

    FrameFilePartialFetch(boolean lastFetchHeaderSet) {
        this.lastFetchHeaderSet = lastFetchHeaderSet;
    }

    public boolean isLastFetch() {
        return this.exceptionCaught == null && this.lastFetchHeaderSet && this.bytesRead == 0L;
    }

    public Throwable getExceptionCaught() {
        if (!this.isExceptionCaught()) {
            throw new ISE("No exception caught", new Object[0]);
        }
        return this.exceptionCaught;
    }

    public boolean isExceptionCaught() {
        return this.exceptionCaught != null;
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    public ListenableFuture<?> backpressureFuture() {
        ListenableFuture<?> future = this.backpressureFuture;
        this.backpressureFuture = null;
        if (future != null) {
            return future;
        }
        return Futures.immediateFuture(null);
    }

    void setBackpressureFuture(ListenableFuture<?> future) {
        if (this.backpressureFuture == null) {
            this.backpressureFuture = future;
        }
    }

    void exceptionCaught(Throwable t) {
        if (this.exceptionCaught == null) {
            this.exceptionCaught = t;
        }
    }

    void addBytesRead(long n) {
        this.bytesRead += n;
    }
}

