/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame;

import javax.annotation.Nullable;

public enum FrameType {
    COLUMNAR(17, false),
    ROW_BASED_V1(18, true),
    ROW_BASED_V2(19, true);

    private final byte versionByte;
    private final boolean rowBased;

    @Nullable
    public static FrameType forVersion(byte versionByte) {
        for (FrameType type : FrameType.values()) {
            if (type.version() != versionByte) continue;
            return type;
        }
        return null;
    }

    public static FrameType latestRowBased() {
        return ROW_BASED_V2;
    }

    public static FrameType latestColumnar() {
        return COLUMNAR;
    }

    private FrameType(byte versionByte, boolean rowBased) {
        this.versionByte = versionByte;
        this.rowBased = rowBased;
    }

    public byte version() {
        return this.versionByte;
    }

    public boolean isRowBased() {
        return this.rowBased;
    }

    public boolean isColumnar() {
        return !this.rowBased;
    }
}

