/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;

public class HttpInputSourceConfig {
    @VisibleForTesting
    public static final Set<String> DEFAULT_ALLOWED_PROTOCOLS = ImmutableSet.of((Object)"http", (Object)"https");
    @JsonProperty
    private final Set<String> allowedProtocols;
    @JsonProperty
    private final Set<String> allowedHeaders;

    @JsonCreator
    public HttpInputSourceConfig(@JsonProperty(value="allowedProtocols") @Nullable Set<String> allowedProtocols, @JsonProperty(value="allowedHeaders") @Nullable Set<String> allowedHeaders) {
        this.allowedProtocols = allowedProtocols == null || allowedProtocols.isEmpty() ? DEFAULT_ALLOWED_PROTOCOLS : allowedProtocols.stream().map(StringUtils::toLowerCase).collect(Collectors.toSet());
        this.allowedHeaders = allowedHeaders == null ? Collections.emptySet() : allowedHeaders.stream().map(StringUtils::toLowerCase).collect(Collectors.toSet());
    }

    public Set<String> getAllowedProtocols() {
        return this.allowedProtocols;
    }

    public Set<String> getAllowedHeaders() {
        return this.allowedHeaders;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpInputSourceConfig that = (HttpInputSourceConfig)o;
        return Objects.equals(this.allowedProtocols, that.allowedProtocols) && Objects.equals(this.allowedHeaders, that.allowedHeaders);
    }

    public int hashCode() {
        return Objects.hash(this.allowedProtocols, this.allowedHeaders);
    }

    public String toString() {
        return "HttpInputSourceConfig{allowedProtocols=" + String.valueOf(this.allowedProtocols) + ", allowedHeaders=" + String.valueOf(this.allowedHeaders) + "}";
    }
}

