/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.serde;

import com.google.common.base.Supplier;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.collections.spatial.ImmutableRTree;
import org.apache.druid.segment.column.ColumnIndexSupplier;
import org.apache.druid.segment.column.StringEncodingStrategies;
import org.apache.druid.segment.data.GenericIndexed;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.index.IndexedStringDictionaryEncodedStringValueIndex;
import org.apache.druid.segment.index.IndexedStringDruidPredicateIndexes;
import org.apache.druid.segment.index.IndexedUtf8LexicographicalRangeIndexes;
import org.apache.druid.segment.index.IndexedUtf8ValueIndexes;
import org.apache.druid.segment.index.SimpleImmutableBitmapIndex;
import org.apache.druid.segment.index.semantic.DictionaryEncodedStringValueIndex;
import org.apache.druid.segment.index.semantic.DictionaryEncodedValueIndex;
import org.apache.druid.segment.index.semantic.DruidPredicateIndexes;
import org.apache.druid.segment.index.semantic.LexicographicalRangeIndexes;
import org.apache.druid.segment.index.semantic.NullValueIndex;
import org.apache.druid.segment.index.semantic.SpatialIndex;
import org.apache.druid.segment.index.semantic.StringValueSetIndexes;
import org.apache.druid.segment.index.semantic.Utf8ValueSetIndexes;
import org.apache.druid.segment.index.semantic.ValueIndexes;
import org.apache.druid.segment.index.semantic.ValueSetIndexes;

public class StringUtf8ColumnIndexSupplier<TIndexed extends Indexed<ByteBuffer>>
implements ColumnIndexSupplier {
    private final BitmapFactory bitmapFactory;
    private final Supplier<TIndexed> utf8Dictionary;
    @Nullable
    private final GenericIndexed<ImmutableBitmap> bitmaps;
    @Nullable
    private final ImmutableRTree indexedTree;

    public StringUtf8ColumnIndexSupplier(BitmapFactory bitmapFactory, Supplier<TIndexed> utf8Dictionary, @Nullable GenericIndexed<ImmutableBitmap> bitmaps, @Nullable ImmutableRTree indexedTree) {
        this.bitmapFactory = bitmapFactory;
        this.bitmaps = bitmaps;
        this.utf8Dictionary = utf8Dictionary;
        this.indexedTree = indexedTree;
    }

    @Override
    @Nullable
    public <T> T as(Class<T> clazz) {
        if (this.bitmaps != null) {
            Indexed dict = (Indexed)this.utf8Dictionary.get();
            GenericIndexed.BufferIndexed singleThreadedBitmaps = this.bitmaps.singleThreaded();
            if (clazz.equals(NullValueIndex.class)) {
                ImmutableBitmap bitmap;
                SimpleImmutableBitmapIndex nullIndex = dict.get(0) == null ? new SimpleImmutableBitmapIndex((bitmap = (ImmutableBitmap)singleThreadedBitmaps.get(0)) == null ? this.bitmapFactory.makeEmptyImmutableBitmap() : bitmap) : new SimpleImmutableBitmapIndex(this.bitmapFactory.makeEmptyImmutableBitmap());
                return (T)((NullValueIndex)() -> nullIndex);
            }
            if (clazz.equals(StringValueSetIndexes.class) || clazz.equals(Utf8ValueSetIndexes.class) || clazz.equals(ValueIndexes.class) || clazz.equals(ValueSetIndexes.class)) {
                return (T)new IndexedUtf8ValueIndexes<Indexed>(this.bitmapFactory, dict, singleThreadedBitmaps);
            }
            if (clazz.equals(DruidPredicateIndexes.class)) {
                return (T)new IndexedStringDruidPredicateIndexes<StringEncodingStrategies.Utf8ToStringIndexed>(this.bitmapFactory, new StringEncodingStrategies.Utf8ToStringIndexed(dict), singleThreadedBitmaps);
            }
            if (clazz.equals(LexicographicalRangeIndexes.class)) {
                return (T)new IndexedUtf8LexicographicalRangeIndexes<Indexed>(this.bitmapFactory, dict, singleThreadedBitmaps, dict.get(0) == null);
            }
            if (clazz.equals(DictionaryEncodedStringValueIndex.class) || clazz.equals(DictionaryEncodedValueIndex.class)) {
                return (T)new IndexedStringDictionaryEncodedStringValueIndex<StringEncodingStrategies.Utf8ToStringIndexed>(this.bitmapFactory, new StringEncodingStrategies.Utf8ToStringIndexed(dict), singleThreadedBitmaps);
            }
        }
        if (this.indexedTree != null && clazz.equals(SpatialIndex.class)) {
            return (T)((SpatialIndex)() -> this.indexedTree);
        }
        return null;
    }
}

