/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import java.util.HashMap;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.query.filter.ColumnIndexSelector;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.BaseColumn;
import org.apache.druid.segment.column.BaseColumnHolder;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.column.ColumnIndexSupplier;
import org.apache.druid.segment.column.SelectableColumn;
import org.apache.druid.segment.selector.settable.SettableColumnValueSelector;

public class ColumnCache
implements ColumnIndexSelector {
    private final HashMap<String, ColumnHolder> holderCache;
    private final QueryableIndex index;
    private final VirtualColumns virtualColumns;
    private final Closer closer;

    public ColumnCache(QueryableIndex index, VirtualColumns virtualColumns, Closer closer) {
        this.index = index;
        this.closer = closer;
        this.virtualColumns = virtualColumns;
        this.holderCache = new HashMap();
    }

    @Override
    @Nullable
    public ColumnHolder getColumnHolder(String columnName) {
        return this.holderCache.computeIfAbsent(columnName, this::makeNewColumnHolder);
    }

    @Override
    public int getNumRows() {
        return this.index.getNumRows();
    }

    @Override
    public BitmapFactory getBitmapFactory() {
        return this.index.getBitmapFactoryForDimensions();
    }

    @Override
    @Nullable
    public ColumnIndexSupplier getIndexSupplier(String column) {
        ColumnHolder holder = this.getColumnHolder(column);
        if (holder != null) {
            return holder.getIndexSupplier();
        }
        return null;
    }

    @Nullable
    private ColumnHolder makeNewColumnHolder(String columnName) {
        VirtualColumn virtualColumn = this.virtualColumns.getVirtualColumn(columnName);
        if (virtualColumn != null) {
            ColumnCapabilities capabilities = virtualColumn.capabilities(this.virtualColumns.wrapInspector(this.index), virtualColumn.getOutputName());
            if (capabilities != null) {
                SelectableColumn selectableColumn = virtualColumn.toSelectableColumn(this);
                return new VirtualColumnHolder(virtualColumn, capabilities, selectableColumn);
            }
            return null;
        }
        BaseColumnHolder holder = this.index.getColumnHolder(columnName);
        if (holder != null) {
            return new WrappedBaseColumnHolder(holder);
        }
        return null;
    }

    private class VirtualColumnHolder
    implements ColumnHolder {
        private final VirtualColumn virtualColumn;
        private final ColumnCapabilities capabilities;
        private final SelectableColumn selectableColumn;

        VirtualColumnHolder(VirtualColumn virtualColumn, ColumnCapabilities capabilities, SelectableColumn selectableColumn) {
            this.virtualColumn = virtualColumn;
            this.capabilities = capabilities;
            this.selectableColumn = selectableColumn;
        }

        @Override
        public ColumnCapabilities getCapabilities() {
            return this.capabilities;
        }

        @Override
        public int getLength() {
            return ColumnCache.this.index.getNumRows();
        }

        @Override
        public SelectableColumn getColumn() {
            return this.selectableColumn;
        }

        @Override
        @Nullable
        public ColumnIndexSupplier getIndexSupplier() {
            return this.virtualColumn.getIndexSupplier(this.virtualColumn.getOutputName(), ColumnCache.this);
        }

        @Override
        public SettableColumnValueSelector makeNewSettableColumnValueSelector() {
            throw DruidException.defensive("Not implemented. This method is expected to only be used with physical columns.", new Object[0]);
        }
    }

    private class WrappedBaseColumnHolder
    implements BaseColumnHolder {
        private final BaseColumnHolder baseHolder;
        @Nullable
        private BaseColumn theColumn = null;

        WrappedBaseColumnHolder(BaseColumnHolder baseHolder) {
            this.baseHolder = baseHolder;
        }

        @Override
        public ColumnCapabilities getCapabilities() {
            return this.baseHolder.getCapabilities();
        }

        @Override
        public int getLength() {
            return this.baseHolder.getLength();
        }

        @Override
        public BaseColumn getColumn() {
            if (this.theColumn == null) {
                this.theColumn = ColumnCache.this.closer.register(this.baseHolder.getColumn());
            }
            return this.theColumn;
        }

        @Override
        @Nullable
        public ColumnIndexSupplier getIndexSupplier() {
            return this.baseHolder.getIndexSupplier();
        }

        @Override
        public SettableColumnValueSelector makeNewSettableColumnValueSelector() {
            return this.baseHolder.makeNewSettableColumnValueSelector();
        }
    }
}

