/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.search;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BinaryOperator;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.query.CacheStrategy;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.Result;
import org.apache.druid.query.ResultGranularTimestampComparator;
import org.apache.druid.query.aggregation.MetricManipulationFn;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.search.BySegmentSearchResultValue;
import org.apache.druid.query.search.DefaultSearchQueryMetricsFactory;
import org.apache.druid.query.search.SearchBinaryFn;
import org.apache.druid.query.search.SearchHit;
import org.apache.druid.query.search.SearchQuery;
import org.apache.druid.query.search.SearchQueryConfig;
import org.apache.druid.query.search.SearchQueryMetrics;
import org.apache.druid.query.search.SearchQueryMetricsFactory;
import org.apache.druid.query.search.SearchResultValue;

public class SearchQueryQueryToolChest
extends QueryToolChest<Result<SearchResultValue>, SearchQuery> {
    private static final byte SEARCH_QUERY = 21;
    private static final TypeReference<Result<SearchResultValue>> TYPE_REFERENCE = new TypeReference<Result<SearchResultValue>>(){};
    private static final TypeReference<Object> OBJECT_TYPE_REFERENCE = new TypeReference<Object>(){};
    private final SearchQueryConfig config;
    private final SearchQueryMetricsFactory queryMetricsFactory;

    @VisibleForTesting
    public SearchQueryQueryToolChest(SearchQueryConfig config) {
        this(config, DefaultSearchQueryMetricsFactory.instance());
    }

    @Inject
    public SearchQueryQueryToolChest(SearchQueryConfig config, SearchQueryMetricsFactory queryMetricsFactory) {
        this.config = config;
        this.queryMetricsFactory = queryMetricsFactory;
    }

    @Override
    public BinaryOperator<Result<SearchResultValue>> createMergeFn(Query<Result<SearchResultValue>> query) {
        SearchQuery searchQuery = (SearchQuery)query;
        return new SearchBinaryFn(searchQuery.getSort(), searchQuery.getGranularity(), searchQuery.getLimit());
    }

    @Override
    public Comparator<Result<SearchResultValue>> createResultComparator(Query<Result<SearchResultValue>> query) {
        return ResultGranularTimestampComparator.create(query.getGranularity(), false);
    }

    public SearchQueryMetrics makeMetrics(SearchQuery query) {
        SearchQueryMetrics metrics = this.queryMetricsFactory.makeMetrics(query);
        metrics.query(query);
        return metrics;
    }

    @Override
    public Function<Result<SearchResultValue>, Result<SearchResultValue>> makePreComputeManipulatorFn(SearchQuery query, MetricManipulationFn fn) {
        return Functions.identity();
    }

    @Override
    public TypeReference<Result<SearchResultValue>> getResultTypeReference() {
        return TYPE_REFERENCE;
    }

    @Override
    public CacheStrategy<Result<SearchResultValue>, Object, SearchQuery> getCacheStrategy(SearchQuery query) {
        return this.getCacheStrategy(query, (ObjectMapper)null);
    }

    @Override
    public CacheStrategy<Result<SearchResultValue>, Object, SearchQuery> getCacheStrategy(final SearchQuery query, @Nullable ObjectMapper objectMapper) {
        return new CacheStrategy<Result<SearchResultValue>, Object, SearchQuery>(){
            private final List<DimensionSpec> dimensionSpecs;
            private final List<String> dimOutputNames;
            {
                this.dimensionSpecs = query.getDimensions() != null ? query.getDimensions() : Collections.emptyList();
                this.dimOutputNames = this.dimensionSpecs.size() > 0 ? Lists.transform(this.dimensionSpecs, DimensionSpec::getOutputName) : Collections.emptyList();
            }

            @Override
            public boolean isCacheable(SearchQuery query2, boolean willMergeRunners, boolean segmentLevel) {
                return true;
            }

            @Override
            public byte[] computeCacheKey(SearchQuery query2) {
                return new CacheKeyBuilder(21).appendInt(query2.getLimit()).appendCacheable(query2.getGranularity()).appendCacheable(query2.getFilter()).appendCacheable(query2.getQuery()).appendCacheable(query2.getSort()).appendCacheables(query2.getDimensions()).appendCacheable(query2.getVirtualColumns()).build();
            }

            @Override
            public byte[] computeResultLevelCacheKey(SearchQuery query2) {
                return this.computeCacheKey(query2);
            }

            @Override
            public TypeReference<Object> getCacheObjectClazz() {
                return OBJECT_TYPE_REFERENCE;
            }

            @Override
            public Function<Result<SearchResultValue>, Object> prepareForCache(boolean isResultLevelCache) {
                return new Function<Result<SearchResultValue>, Object>(){

                    public Object apply(Result<SearchResultValue> input) {
                        return dimensionSpecs.size() > 0 ? Lists.newArrayList((Object[])new Object[]{input.getTimestamp().getMillis(), input.getValue(), dimOutputNames}) : Lists.newArrayList((Object[])new Object[]{input.getTimestamp().getMillis(), input.getValue()});
                    }
                };
            }

            @Override
            public Function<Object, Result<SearchResultValue>> pullFromCache(boolean isResultLevelCache) {
                return new Function<Object, Result<SearchResultValue>>(){

                    public Result<SearchResultValue> apply(Object input) {
                        List result = (List)input;
                        boolean needsRename = false;
                        final HashMap<String, String> outputNameMap = new HashMap<String, String>();
                        if (this.hasOutputName(result)) {
                            List cachedOutputNames = (List)result.get(2);
                            Preconditions.checkArgument((cachedOutputNames.size() == dimOutputNames.size() ? 1 : 0) != 0, (Object)"cache hit, but number of dimensions mismatch");
                            needsRename = false;
                            for (int idx = 0; idx < cachedOutputNames.size(); ++idx) {
                                String outputName;
                                String cachedOutputName = (String)cachedOutputNames.get(idx);
                                if (!cachedOutputName.equals(outputName = dimOutputNames.get(idx))) {
                                    needsRename = true;
                                }
                                outputNameMap.put(cachedOutputName, outputName);
                            }
                        }
                        return !needsRename ? new Result<SearchResultValue>(DateTimes.utc(((Number)result.get(0)).longValue()), new SearchResultValue(Lists.transform((List)((List)result.get(1)), (Function)new Function<Object, SearchHit>(){

                            public SearchHit apply(@Nullable Object input) {
                                if (input instanceof Map) {
                                    return new SearchHit((String)((Map)input).get("dimension"), (String)((Map)input).get("value"), (Integer)((Map)input).get("count"));
                                }
                                if (input instanceof SearchHit) {
                                    return (SearchHit)input;
                                }
                                throw new IAE("Unknown format [%s]", input.getClass());
                            }
                        }))) : new Result<SearchResultValue>(DateTimes.utc(((Number)result.get(0)).longValue()), new SearchResultValue(Lists.transform((List)((List)result.get(1)), (Function)new Function<Object, SearchHit>(){

                            public SearchHit apply(@Nullable Object input) {
                                Integer count;
                                String val;
                                String dim;
                                if (input instanceof Map) {
                                    dim = (String)outputNameMap.get((String)((Map)input).get("dimension"));
                                    val = (String)((Map)input).get("value");
                                    count = (Integer)((Map)input).get("count");
                                } else if (input instanceof SearchHit) {
                                    SearchHit cached = (SearchHit)input;
                                    dim = (String)outputNameMap.get(cached.getDimension());
                                    val = cached.getValue();
                                    count = cached.getCount();
                                } else {
                                    throw new IAE("Unknown format [%s]", input.getClass());
                                }
                                return new SearchHit(dim, val, count);
                            }
                        })));
                    }
                };
            }

            private boolean hasOutputName(List<Object> cachedEntry) {
                return cachedEntry.size() == 3;
            }
        };
    }

    @Override
    public QueryRunner<Result<SearchResultValue>> preMergeQueryDecoration(QueryRunner<Result<SearchResultValue>> runner) {
        return new SearchThresholdAdjustingQueryRunner((queryPlus, responseContext) -> runner.run(queryPlus, responseContext), this.config);
    }

    private static class SearchThresholdAdjustingQueryRunner
    implements QueryRunner<Result<SearchResultValue>> {
        private final QueryRunner<Result<SearchResultValue>> runner;
        private final SearchQueryConfig config;

        public SearchThresholdAdjustingQueryRunner(QueryRunner<Result<SearchResultValue>> runner, SearchQueryConfig config) {
            this.runner = runner;
            this.config = config;
        }

        @Override
        public Sequence<Result<SearchResultValue>> run(QueryPlus<Result<SearchResultValue>> queryPlus, ResponseContext responseContext) {
            Query<Result<SearchResultValue>> input = queryPlus.getQuery();
            if (!(input instanceof SearchQuery)) {
                throw new ISE("Can only handle [%s], got [%s]", SearchQuery.class, input.getClass());
            }
            final SearchQuery query = (SearchQuery)input;
            if (query.getLimit() < this.config.getMaxSearchLimit()) {
                return this.runner.run(queryPlus, responseContext);
            }
            final boolean isBySegment = query.context().isBySegment();
            return Sequences.map(this.runner.run(queryPlus.withQuery(query.withLimit(this.config.getMaxSearchLimit())), responseContext), new Function<Result<SearchResultValue>, Result<SearchResultValue>>(){

                public Result<SearchResultValue> apply(Result<SearchResultValue> input) {
                    if (isBySegment) {
                        BySegmentSearchResultValue value = (BySegmentSearchResultValue)input.getValue();
                        return new Result<SearchResultValue>(input.getTimestamp(), new BySegmentSearchResultValue(Lists.transform(value.getResults(), (Function)new Function<Result<SearchResultValue>, Result<SearchResultValue>>(){

                            public Result<SearchResultValue> apply(@Nullable Result<SearchResultValue> input) {
                                return new Result<SearchResultValue>(input.getTimestamp(), new SearchResultValue(Lists.newArrayList((Iterable)Iterables.limit((Iterable)input.getValue(), (int)query.getLimit()))));
                            }
                        }), value.getSegmentId(), value.getInterval()));
                    }
                    return new Result<SearchResultValue>(input.getTimestamp(), new SearchResultValue(Lists.newArrayList((Iterable)Iterables.limit((Iterable)input.getValue(), (int)query.getLimit()))));
                }
            });
        }
    }
}

