/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.cardinality.vector;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.druid.hll.HyperLogLogCollector;
import org.apache.druid.query.aggregation.cardinality.types.StringCardinalityAggregatorColumnSelectorStrategy;
import org.apache.druid.query.aggregation.cardinality.vector.CardinalityVectorProcessor;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.vector.MultiValueDimensionVectorSelector;

public class MultiValueStringCardinalityVectorProcessor
implements CardinalityVectorProcessor {
    private final MultiValueDimensionVectorSelector selector;

    public MultiValueStringCardinalityVectorProcessor(MultiValueDimensionVectorSelector selector) {
        this.selector = selector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void aggregate(ByteBuffer buf, int position, int startRow, int endRow) {
        int oldPosition = buf.position();
        int oldLimit = buf.limit();
        try {
            IndexedInts[] vector = this.selector.getRowVector();
            buf.limit(position + HyperLogLogCollector.getLatestNumBytesForDenseStorage());
            buf.position(position);
            HyperLogLogCollector collector = HyperLogLogCollector.makeCollector(buf);
            for (int i = startRow; i < endRow; ++i) {
                IndexedInts ids = vector[i];
                int sz = ids.size();
                for (int j = 0; j < sz; ++j) {
                    String value = this.selector.lookupName(ids.get(j));
                    StringCardinalityAggregatorColumnSelectorStrategy.addStringToCollector(collector, value);
                }
            }
        }
        finally {
            buf.limit(oldLimit);
            buf.position(oldPosition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void aggregate(ByteBuffer buf, int numRows, int[] positions, @Nullable int[] rows, int positionOffset) {
        int oldPosition = buf.position();
        int oldLimit = buf.limit();
        try {
            IndexedInts[] vector = this.selector.getRowVector();
            for (int i = 0; i < numRows; ++i) {
                IndexedInts ids = vector[rows != null ? rows[i] : i];
                int sz = ids.size();
                for (int j = 0; j < sz; ++j) {
                    String s = this.selector.lookupName(ids.get(j));
                    if (s == null) continue;
                    int position = positions[i] + positionOffset;
                    buf.limit(position + HyperLogLogCollector.getLatestNumBytesForDenseStorage());
                    buf.position(position);
                    HyperLogLogCollector collector = HyperLogLogCollector.makeCollector(buf);
                    StringCardinalityAggregatorColumnSelectorStrategy.addStringToCollector(collector, s);
                }
            }
        }
        finally {
            buf.limit(oldLimit);
            buf.position(oldPosition);
        }
    }
}

