/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common.parsers;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.apache.druid.java.util.common.parsers.JSONPathFieldSpec;

public class JSONPathSpec {
    public static final JSONPathSpec DEFAULT = new JSONPathSpec(null, null);
    private final boolean useFieldDiscovery;
    private final List<JSONPathFieldSpec> fields;

    @JsonCreator
    public JSONPathSpec(@JsonProperty(value="useFieldDiscovery") Boolean useFieldDiscovery, @JsonProperty(value="fields") List<JSONPathFieldSpec> fields) {
        this.useFieldDiscovery = useFieldDiscovery == null ? true : useFieldDiscovery;
        this.fields = fields == null ? ImmutableList.of() : fields;
    }

    @JsonProperty
    public boolean isUseFieldDiscovery() {
        return this.useFieldDiscovery;
    }

    @JsonProperty
    public List<JSONPathFieldSpec> getFields() {
        return this.fields;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JSONPathSpec that = (JSONPathSpec)o;
        return this.useFieldDiscovery == that.useFieldDiscovery && Objects.equals(this.fields, that.fields);
    }

    public int hashCode() {
        return Objects.hash(this.useFieldDiscovery, this.fields);
    }

    public String toString() {
        return "JSONPathSpec{useFieldDiscovery=" + this.useFieldDiscovery + ", fields=" + this.fields + "}";
    }
}

