/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common.parsers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import org.apache.druid.java.util.common.parsers.JSONFlattenerMaker;
import org.apache.druid.java.util.common.parsers.JSONPathSpec;
import org.apache.druid.java.util.common.parsers.ObjectFlattener;
import org.apache.druid.java.util.common.parsers.ObjectFlatteners;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.apache.druid.java.util.common.parsers.Parser;

public class JSONPathParser
implements Parser<String, Object> {
    private final ObjectMapper mapper;
    private final ObjectFlattener<JsonNode> flattener;

    public JSONPathParser(JSONPathSpec flattenSpec, ObjectMapper mapper, boolean keepNullColumns) {
        this.mapper = mapper == null ? new ObjectMapper() : mapper;
        this.flattener = ObjectFlatteners.create(flattenSpec, new JSONFlattenerMaker(keepNullColumns, false));
    }

    @Override
    public List<String> getFieldNames() {
        return null;
    }

    @Override
    public void setFieldNames(Iterable<String> fieldNames) {
    }

    @Override
    public Map<String, Object> parseToMap(String input) {
        try {
            JsonNode document = (JsonNode)this.mapper.readValue(input, JsonNode.class);
            return this.flattener.flatten(document);
        }
        catch (Exception e) {
            throw new ParseException(input, (Throwable)e, "Unable to parse row [%s]", input);
        }
    }
}

