/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.guice;

import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Scope;
import java.util.ArrayList;
import java.util.List;
import org.apache.druid.java.util.common.lifecycle.Lifecycle;
import org.apache.druid.java.util.common.logger.Logger;

public class LifecycleScope
implements Scope {
    private static final Logger log = new Logger(LifecycleScope.class);
    private final Lifecycle.Stage stage;
    private Lifecycle lifecycle;
    private final List<Object> instances = new ArrayList<Object>();

    public LifecycleScope(Lifecycle.Stage stage) {
        this.stage = stage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLifecycle(Lifecycle lifecycle) {
        List<Object> list = this.instances;
        synchronized (list) {
            this.lifecycle = lifecycle;
            for (Object instance : this.instances) {
                lifecycle.addManagedInstance(instance, this.stage);
            }
        }
    }

    public <T> Provider<T> scope(final Key<T> key, final Provider<T> unscoped) {
        return new Provider<T>(){
            private volatile T value = null;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public synchronized T get() {
                if (this.value == null) {
                    Object retVal = unscoped.get();
                    List<Object> list = LifecycleScope.this.instances;
                    synchronized (list) {
                        if (LifecycleScope.this.lifecycle == null) {
                            LifecycleScope.this.instances.add(retVal);
                        } else {
                            try {
                                LifecycleScope.this.lifecycle.addMaybeStartManagedInstance(retVal, LifecycleScope.this.stage);
                            }
                            catch (Exception e) {
                                log.warn(e, "Caught exception when trying to create a[%s]", key);
                                return null;
                            }
                        }
                    }
                    this.value = retVal;
                }
                return this.value;
            }
        };
    }
}

