/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.write.columnar;

import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.frame.allocation.MemoryAllocator;
import org.apache.druid.frame.write.columnar.NumericArrayFrameColumnWriter;
import org.apache.druid.segment.ColumnValueSelector;

public class FloatArrayFrameColumnWriter
extends NumericArrayFrameColumnWriter {
    public FloatArrayFrameColumnWriter(ColumnValueSelector selector, MemoryAllocator allocator) {
        super(selector, allocator, (byte)8);
    }

    @Override
    int elementSizeBytes() {
        return 4;
    }

    @Override
    void putNull(WritableMemory memory, long offset) {
        memory.putFloat(offset, 0.0f);
    }

    @Override
    void putArrayElement(WritableMemory memory, long offset, Number element) {
        memory.putFloat(offset, element.floatValue());
    }
}

