/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input;

import com.google.common.base.Predicate;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputEntity;
import org.apache.druid.data.input.InputStats;
import org.apache.druid.java.util.common.FileUtils;

public class BytesCountingInputEntity
implements InputEntity {
    private final InputStats inputStats;
    private final InputEntity baseInputEntity;

    public BytesCountingInputEntity(InputEntity baseInputEntity, InputStats inputStats) {
        this.baseInputEntity = baseInputEntity;
        this.inputStats = inputStats;
    }

    @Override
    @Nullable
    public URI getUri() {
        return this.baseInputEntity.getUri();
    }

    @Override
    public InputStream open() throws IOException {
        return new BytesCountingInputStream(this.baseInputEntity.open(), this.inputStats);
    }

    public InputEntity getBaseInputEntity() {
        return this.baseInputEntity;
    }

    @Override
    public InputEntity.CleanableFile fetch(File temporaryDirectory, byte[] fetchBuffer) throws IOException {
        InputEntity.CleanableFile cleanableFile = this.baseInputEntity.fetch(temporaryDirectory, fetchBuffer);
        this.inputStats.incrementProcessedBytes(FileUtils.getFileSize(cleanableFile.file()));
        return cleanableFile;
    }

    @Override
    public Predicate<Throwable> getRetryCondition() {
        return this.baseInputEntity.getRetryCondition();
    }

    private static class BytesCountingInputStream
    extends FilterInputStream {
        private final InputStats inputStats;

        BytesCountingInputStream(@Nullable InputStream in, InputStats inputStats) {
            super(in);
            this.inputStats = inputStats;
        }

        @Override
        public int read() throws IOException {
            int result = this.in.read();
            if (result != -1) {
                this.inputStats.incrementProcessedBytes(1L);
            }
            return result;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int result = this.in.read(b, off, len);
            if (result != -1) {
                this.inputStats.incrementProcessedBytes(result);
            }
            return result;
        }

        @Override
        public long skip(long n) throws IOException {
            long result = this.in.skip(n);
            this.inputStats.incrementProcessedBytes(result);
            return result;
        }
    }
}

