/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.collections;

import it.unimi.dsi.fastutil.ints.AbstractIntSortedSet;
import it.unimi.dsi.fastutil.ints.IntBidirectionalIterator;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.ints.IntIterators;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import it.unimi.dsi.fastutil.ints.IntSortedSets;
import java.util.NoSuchElementException;

public class RangeIntSet
extends AbstractIntSortedSet {
    private final int start;
    private final int end;

    public RangeIntSet(int start, int end) {
        this.start = start;
        this.end = end;
    }

    public IntBidirectionalIterator iterator() {
        return IntIterators.fromTo((int)this.start, (int)this.end);
    }

    public IntBidirectionalIterator iterator(int fromElement) {
        if (fromElement < this.end) {
            return IntIterators.fromTo((int)Math.max(this.start, fromElement), (int)this.end);
        }
        return IntIterators.EMPTY_ITERATOR;
    }

    public boolean contains(int k) {
        return k >= this.start && k < this.end;
    }

    public IntSortedSet subSet(int fromElement, int toElement) {
        if (fromElement < this.end && toElement > this.start) {
            return new RangeIntSet(Math.max(fromElement, this.start), Math.min(toElement, this.end));
        }
        return IntSortedSets.EMPTY_SET;
    }

    public IntSortedSet headSet(int toElement) {
        if (toElement > this.start) {
            return new RangeIntSet(this.start, Math.min(toElement, this.end));
        }
        return IntSortedSets.EMPTY_SET;
    }

    public IntSortedSet tailSet(int fromElement) {
        if (fromElement < this.end) {
            return new RangeIntSet(Math.max(this.start, fromElement), this.end);
        }
        return IntSortedSets.EMPTY_SET;
    }

    public IntComparator comparator() {
        return null;
    }

    public int firstInt() {
        if (this.start < this.end) {
            return this.start;
        }
        throw new NoSuchElementException();
    }

    public int lastInt() {
        if (this.start < this.end) {
            return this.end - 1;
        }
        throw new NoSuchElementException();
    }

    public int size() {
        return this.end > this.start ? this.end - this.start : 0;
    }

    public boolean isEmpty() {
        return this.end <= this.start;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof RangeIntSet) {
            RangeIntSet other = (RangeIntSet)((Object)o);
            return other.start == this.start && other.end == this.end || other.isEmpty() && this.isEmpty();
        }
        return super.equals(o);
    }

    public int hashCode() {
        return this.isEmpty() ? 0 : this.start + 31 * this.end;
    }
}

