/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.virtual;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.RowIdSupplier;
import org.apache.druid.segment.virtual.BaseExpressionColumnValueSelector;

public class ExpressionColumnValueSelector
extends BaseExpressionColumnValueSelector {
    private final Expr.ObjectBinding bindings;
    private final Expr expression;

    public ExpressionColumnValueSelector(Expr expression, Expr.ObjectBinding bindings, @Nullable RowIdSupplier rowIdSupplier) {
        super(rowIdSupplier);
        this.bindings = (Expr.ObjectBinding)Preconditions.checkNotNull((Object)bindings, (Object)"bindings");
        this.expression = (Expr)Preconditions.checkNotNull((Object)expression, (Object)"expression");
    }

    @Override
    protected ExprEval<?> eval() {
        return this.expression.eval(this.bindings);
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        super.inspectRuntimeShape(inspector);
        inspector.visit("expression", this.expression);
        inspector.visit("bindings", this.bindings);
    }
}

