/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.BitmapResultFactory;
import org.apache.druid.query.filter.BooleanFilter;
import org.apache.druid.query.filter.ColumnIndexSelector;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.FilterBundle;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.filter.vector.BaseVectorValueMatcher;
import org.apache.druid.query.filter.vector.BooleanVectorValueMatcher;
import org.apache.druid.query.filter.vector.ReadableVectorMatch;
import org.apache.druid.query.filter.vector.VectorMatch;
import org.apache.druid.query.filter.vector.VectorValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.BitmapOffset;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.column.ColumnIndexCapabilities;
import org.apache.druid.segment.column.SimpleColumnIndexCapabilities;
import org.apache.druid.segment.data.Offset;
import org.apache.druid.segment.data.ReadableOffset;
import org.apache.druid.segment.filter.AndFilter;
import org.apache.druid.segment.filter.ConstantMatcherType;
import org.apache.druid.segment.filter.ValueMatchers;
import org.apache.druid.segment.index.BitmapColumnIndex;
import org.apache.druid.segment.vector.ReadableVectorOffset;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.roaringbitmap.IntIterator;
import org.roaringbitmap.PeekableIntIterator;

public class OrFilter
implements BooleanFilter {
    private static final Joiner OR_JOINER = Joiner.on((String)" || ");
    private final LinkedHashSet<Filter> filters;

    public OrFilter(LinkedHashSet<Filter> filters) {
        Preconditions.checkArgument((filters.size() > 0 ? 1 : 0) != 0, (Object)"Can't construct empty OrFilter (the universe does not exist)");
        this.filters = filters;
    }

    public OrFilter(List<Filter> filters) {
        this(new LinkedHashSet<Filter>(filters));
    }

    private static ValueMatcher makeMatcher(final ValueMatcher[] baseMatchers) {
        Preconditions.checkState((baseMatchers.length > 0 ? 1 : 0) != 0);
        if (baseMatchers.length == 1) {
            return baseMatchers[0];
        }
        return new ValueMatcher(){

            @Override
            public boolean matches(boolean includeUnknown) {
                for (ValueMatcher matcher : baseMatchers) {
                    if (!matcher.matches(includeUnknown)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("firstBaseMatcher", baseMatchers[0]);
                inspector.visit("secondBaseMatcher", baseMatchers[1]);
            }
        };
    }

    private static VectorValueMatcher makeVectorMatcher(final VectorValueMatcher[] baseMatchers) {
        Preconditions.checkState((baseMatchers.length > 0 ? 1 : 0) != 0);
        if (baseMatchers.length == 1) {
            return baseMatchers[0];
        }
        return new BaseVectorValueMatcher(baseMatchers[0]){
            final VectorMatch currentMask;
            final VectorMatch scratch;
            final VectorMatch retVal;
            {
                super(selector);
                this.currentMask = VectorMatch.wrap(new int[this.getMaxVectorSize()]);
                this.scratch = VectorMatch.wrap(new int[this.getMaxVectorSize()]);
                this.retVal = VectorMatch.wrap(new int[this.getMaxVectorSize()]);
            }

            @Override
            public ReadableVectorMatch match(ReadableVectorMatch mask, boolean includeUnknown) {
                ReadableVectorMatch currentMatch = baseMatchers[0].match(mask, includeUnknown);
                this.currentMask.copyFrom(mask);
                this.retVal.copyFrom(currentMatch);
                for (int i = 1; i < baseMatchers.length && !this.retVal.isAllTrue(this.getCurrentVectorSize()); ++i) {
                    this.currentMask.removeAll(currentMatch);
                    currentMatch = baseMatchers[i].match(this.currentMask, includeUnknown);
                    this.retVal.addAll(currentMatch, this.scratch);
                    if (currentMatch == this.currentMask) break;
                }
                assert (this.retVal.isValid(mask));
                return this.retVal;
            }
        };
    }

    private static FilterBundle.MatcherBundle convertBundleToMatcherOnlyBundle(final FilterBundle bundle, final ImmutableBitmap bundleIndex) {
        return new FilterBundle.MatcherBundle(){

            @Override
            public FilterBundle.MatcherBundleInfo getMatcherInfo() {
                return new FilterBundle.MatcherBundleInfo(() -> "AND", bundle.getIndex().getIndexInfo(), Collections.singletonList(bundle.getMatcherBundle().getMatcherInfo()));
            }

            @Override
            public ValueMatcher valueMatcher(ColumnSelectorFactory selectorFactory, Offset baseOffset, boolean descending) {
                return AndFilter.makeMatcher(new ValueMatcher[]{OrFilter.convertIndexToValueMatcher(baseOffset.getBaseReadableOffset(), bundleIndex, descending), bundle.getMatcherBundle().valueMatcher(selectorFactory, baseOffset, descending)});
            }

            @Override
            public VectorValueMatcher vectorMatcher(VectorColumnSelectorFactory selectorFactory, ReadableVectorOffset baseOffset) {
                return AndFilter.makeVectorMatcher(new VectorValueMatcher[]{OrFilter.convertIndexToVectorValueMatcher(baseOffset, bundleIndex), bundle.getMatcherBundle().vectorMatcher(selectorFactory, baseOffset)});
            }

            @Override
            public boolean canVectorize() {
                return bundle.getMatcherBundle() == null || bundle.getMatcherBundle().canVectorize();
            }
        };
    }

    private static FilterBundle.MatcherBundle convertIndexToMatcherBundle(final int selectionRowCount, final List<FilterBundle.IndexBundle> indexOnlyBundles, final List<FilterBundle.IndexBundleInfo> indexOnlyBundlesInfo, final long totalBitmapConstructTimeNs, final ImmutableBitmap partialIndex) {
        return new FilterBundle.MatcherBundle(){

            @Override
            public FilterBundle.MatcherBundleInfo getMatcherInfo() {
                if (indexOnlyBundles.size() == 1) {
                    return new FilterBundle.MatcherBundleInfo(((FilterBundle.IndexBundle)indexOnlyBundles.get(0)).getIndexInfo()::getFilter, ((FilterBundle.IndexBundle)indexOnlyBundles.get(0)).getIndexInfo(), null);
                }
                return new FilterBundle.MatcherBundleInfo(() -> "OR", new FilterBundle.IndexBundleInfo(() -> "OR", selectionRowCount, totalBitmapConstructTimeNs, indexOnlyBundlesInfo), null);
            }

            @Override
            public ValueMatcher valueMatcher(ColumnSelectorFactory selectorFactory, Offset baseOffset, boolean descending) {
                return OrFilter.convertIndexToValueMatcher(baseOffset.getBaseReadableOffset(), partialIndex, descending);
            }

            @Override
            public VectorValueMatcher vectorMatcher(VectorColumnSelectorFactory selectorFactory, ReadableVectorOffset baseOffset) {
                return OrFilter.convertIndexToVectorValueMatcher(baseOffset, partialIndex);
            }

            @Override
            public boolean canVectorize() {
                return true;
            }
        };
    }

    private static ValueMatcher convertIndexToValueMatcher(final ReadableOffset offset, final ImmutableBitmap rowBitmap, boolean descending) {
        if (descending) {
            final IntIterator initialIterator = BitmapOffset.getReverseBitmapOffsetIterator(rowBitmap);
            if (!initialIterator.hasNext()) {
                return ValueMatchers.allFalse();
            }
            return new ValueMatcher(){
                int iterOffset = Integer.MAX_VALUE;
                int previousOffset = Integer.MAX_VALUE;
                IntIterator iterator = initialIterator;

                @Override
                public boolean matches(boolean includeUnknown) {
                    int currentOffset = offset.getOffset();
                    if (currentOffset >= this.previousOffset) {
                        this.iterOffset = Integer.MAX_VALUE;
                        this.iterator = BitmapOffset.getReverseBitmapOffsetIterator(rowBitmap);
                    }
                    this.previousOffset = currentOffset;
                    while (this.iterOffset > currentOffset && this.iterator.hasNext()) {
                        this.iterOffset = this.iterator.next();
                    }
                    return this.iterOffset == currentOffset;
                }

                @Override
                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                    inspector.visit("offset", offset);
                    inspector.visit("iter", this.iterator);
                }
            };
        }
        final PeekableIntIterator initialIterator = rowBitmap.peekableIterator();
        if (!initialIterator.hasNext()) {
            return ValueMatchers.allFalse();
        }
        return new ValueMatcher(){
            int iterOffset = -1;
            int previousOffset = -1;
            PeekableIntIterator iterator = initialIterator;

            @Override
            public boolean matches(boolean includeUnknown) {
                int currentOffset = offset.getOffset();
                if (currentOffset <= this.previousOffset) {
                    this.iterOffset = -1;
                    this.iterator = rowBitmap.peekableIterator();
                }
                this.previousOffset = currentOffset;
                this.iterator.advanceIfNeeded(currentOffset);
                if (this.iterator.hasNext()) {
                    this.iterOffset = this.iterator.peekNext();
                }
                return this.iterOffset == currentOffset;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("offset", offset);
                inspector.visit("peekableIterator", this.iterator);
            }
        };
    }

    private static VectorValueMatcher convertIndexToVectorValueMatcher(final ReadableVectorOffset vectorOffset, final ImmutableBitmap bitmap) {
        final PeekableIntIterator initialIterator = bitmap.peekableIterator();
        if (!initialIterator.hasNext()) {
            return BooleanVectorValueMatcher.of(vectorOffset, ConstantMatcherType.ALL_FALSE);
        }
        return new VectorValueMatcher(){
            final VectorMatch match;
            int iterOffset;
            int previousStartOffset;
            PeekableIntIterator iterator;
            {
                this.match = VectorMatch.wrap(new int[vectorOffset.getMaxVectorSize()]);
                this.iterOffset = -1;
                this.previousStartOffset = -1;
                this.iterator = initialIterator;
            }

            @Override
            public ReadableVectorMatch match(ReadableVectorMatch mask, boolean includeUnknown) {
                int[] selection = this.match.getSelection();
                if (vectorOffset.isContiguous()) {
                    int startOffset = vectorOffset.getStartOffset();
                    if (startOffset <= this.previousStartOffset) {
                        this.iterOffset = -1;
                        this.iterator = bitmap.peekableIterator();
                    }
                    this.previousStartOffset = startOffset;
                    int numRows = 0;
                    for (int i = 0; i < mask.getSelectionSize(); ++i) {
                        int maskNum = mask.getSelection()[i];
                        int rowNum = startOffset + maskNum;
                        this.iterator.advanceIfNeeded(rowNum);
                        if (!this.iterator.hasNext()) continue;
                        this.iterOffset = this.iterator.peekNext();
                        if (this.iterOffset != rowNum) continue;
                        selection[numRows++] = maskNum;
                    }
                    this.match.setSelectionSize(numRows);
                    return this.match;
                }
                int[] currentOffsets = vectorOffset.getOffsets();
                if (this.getCurrentVectorSize() > 0 && currentOffsets[0] <= this.previousStartOffset) {
                    this.iterOffset = -1;
                    this.iterator = bitmap.peekableIterator();
                }
                this.previousStartOffset = currentOffsets[0];
                int numRows = 0;
                for (int i = 0; i < mask.getSelectionSize(); ++i) {
                    int maskNum = mask.getSelection()[i];
                    int rowNum = currentOffsets[mask.getSelection()[i]];
                    this.iterator.advanceIfNeeded(rowNum);
                    if (!this.iterator.hasNext()) continue;
                    this.iterOffset = this.iterator.peekNext();
                    if (this.iterOffset != rowNum) continue;
                    selection[numRows++] = maskNum;
                }
                this.match.setSelectionSize(numRows);
                return this.match;
            }

            @Override
            public int getMaxVectorSize() {
                return vectorOffset.getMaxVectorSize();
            }

            @Override
            public int getCurrentVectorSize() {
                return vectorOffset.getCurrentVectorSize();
            }
        };
    }

    @Override
    public <T> FilterBundle makeFilterBundle(FilterBundle.Builder filterBundleBuilder, BitmapResultFactory<T> bitmapResultFactory, int applyRowCount, int totalRowCount, boolean includeUnknown) {
        ArrayList<FilterBundle.IndexBundle> indexOnlyBundles = new ArrayList<FilterBundle.IndexBundle>();
        ArrayList<FilterBundle.IndexBundleInfo> indexOnlyBundlesInfo = new ArrayList<FilterBundle.IndexBundleInfo>();
        ArrayList<FilterBundle.MatcherBundle> partialIndexBundles = new ArrayList<FilterBundle.MatcherBundle>();
        ArrayList<FilterBundle.MatcherBundle> matcherOnlyBundles = new ArrayList<FilterBundle.MatcherBundle>();
        int indexUnionSize = 0;
        ImmutableBitmap index = null;
        SimpleColumnIndexCapabilities merged = new SimpleColumnIndexCapabilities(true, true);
        int emptyCount = 0;
        long bitmapConstructionStartNs = System.nanoTime();
        for (FilterBundle.Builder subFilterBundleBuilder : filterBundleBuilder.getChildBuilders()) {
            FilterBundle bundle = subFilterBundleBuilder.build(bitmapResultFactory, Math.min(applyRowCount, totalRowCount - indexUnionSize), totalRowCount, includeUnknown);
            if (bundle.hasIndex()) {
                ImmutableBitmap bundleIndex = bundle.getIndex().getBitmap();
                if (bundleIndex.isEmpty()) {
                    ++emptyCount;
                    continue;
                }
                if (bundle.hasMatcher()) {
                    partialIndexBundles.add(OrFilter.convertBundleToMatcherOnlyBundle(bundle, bundleIndex));
                    continue;
                }
                indexOnlyBundles.add(bundle.getIndex());
                indexOnlyBundlesInfo.add(bundle.getIndex().getIndexInfo());
                merged.merge(bundle.getIndex().getIndexCapabilities());
                index = index == null ? bundle.getIndex().getBitmap() : index.union(bundle.getIndex().getBitmap());
                indexUnionSize = index.size();
                continue;
            }
            matcherOnlyBundles.add(bundle.getMatcherBundle());
        }
        long totalBitmapConstructTimeNs = System.nanoTime() - bitmapConstructionStartNs;
        if (indexOnlyBundles.size() + emptyCount == this.filters.size()) {
            if (index == null || index.isEmpty()) {
                return FilterBundle.allFalse(totalBitmapConstructTimeNs, filterBundleBuilder.getColumnIndexSelector().getBitmapFactory().makeEmptyImmutableBitmap());
            }
            if (indexOnlyBundles.size() == 1) {
                return new FilterBundle((FilterBundle.IndexBundle)indexOnlyBundles.get(0), null);
            }
            return new FilterBundle(new FilterBundle.SimpleIndexBundle(new FilterBundle.IndexBundleInfo(() -> "OR", applyRowCount, totalBitmapConstructTimeNs, indexOnlyBundlesInfo), index, merged), null);
        }
        int estimatedSize = (indexOnlyBundles.isEmpty() ? 0 : 1) + partialIndexBundles.size() + matcherOnlyBundles.size();
        final ArrayList allMatcherBundles = Lists.newArrayListWithCapacity((int)estimatedSize);
        final ArrayList allMatcherBundlesInfo = Lists.newArrayListWithCapacity((int)estimatedSize);
        if (!indexOnlyBundles.isEmpty()) {
            FilterBundle.MatcherBundle matcherBundle = OrFilter.convertIndexToMatcherBundle(applyRowCount, indexOnlyBundles, indexOnlyBundlesInfo, totalBitmapConstructTimeNs, index);
            allMatcherBundles.add(matcherBundle);
            allMatcherBundlesInfo.add(matcherBundle.getMatcherInfo());
        }
        for (FilterBundle.MatcherBundle bundle : partialIndexBundles) {
            allMatcherBundles.add(bundle);
            allMatcherBundlesInfo.add(bundle.getMatcherInfo());
        }
        for (FilterBundle.MatcherBundle bundle : matcherOnlyBundles) {
            allMatcherBundles.add(bundle);
            allMatcherBundlesInfo.add(bundle.getMatcherInfo());
        }
        return new FilterBundle(null, new FilterBundle.MatcherBundle(){

            @Override
            public FilterBundle.MatcherBundleInfo getMatcherInfo() {
                return new FilterBundle.MatcherBundleInfo(() -> "OR", null, allMatcherBundlesInfo);
            }

            @Override
            public ValueMatcher valueMatcher(ColumnSelectorFactory selectorFactory, Offset baseOffset, boolean descending) {
                ValueMatcher[] matchers = new ValueMatcher[allMatcherBundles.size()];
                for (int i = 0; i < allMatcherBundles.size(); ++i) {
                    matchers[i] = ((FilterBundle.MatcherBundle)allMatcherBundles.get(i)).valueMatcher(selectorFactory, baseOffset, descending);
                }
                return OrFilter.makeMatcher(matchers);
            }

            @Override
            public VectorValueMatcher vectorMatcher(VectorColumnSelectorFactory selectorFactory, ReadableVectorOffset baseOffset) {
                VectorValueMatcher[] matchers = new VectorValueMatcher[allMatcherBundles.size()];
                for (int i = 0; i < allMatcherBundles.size(); ++i) {
                    matchers[i] = ((FilterBundle.MatcherBundle)allMatcherBundles.get(i)).vectorMatcher(selectorFactory, baseOffset);
                }
                return OrFilter.makeVectorMatcher(matchers);
            }

            @Override
            public boolean canVectorize() {
                for (FilterBundle.MatcherBundle bundle : allMatcherBundles) {
                    if (bundle.canVectorize()) continue;
                    return false;
                }
                return true;
            }
        });
    }

    @Override
    @Nullable
    public BitmapColumnIndex getBitmapColumnIndex(ColumnIndexSelector selector) {
        if (this.filters.size() == 1) {
            return ((Filter)Iterables.getOnlyElement(this.filters)).getBitmapColumnIndex(selector);
        }
        final ArrayList<BitmapColumnIndex> bitmapColumnIndices = new ArrayList<BitmapColumnIndex>(this.filters.size());
        ColumnIndexCapabilities merged = new SimpleColumnIndexCapabilities(true, true);
        for (Filter filter : this.filters) {
            BitmapColumnIndex index = filter.getBitmapColumnIndex(selector);
            if (index == null) {
                return null;
            }
            merged = merged.merge(index.getIndexCapabilities());
            bitmapColumnIndices.add(index);
        }
        final SimpleColumnIndexCapabilities finalMerged = merged;
        return new BitmapColumnIndex(){

            @Override
            public ColumnIndexCapabilities getIndexCapabilities() {
                return finalMerged;
            }

            @Override
            public int estimatedComputeCost() {
                return 0;
            }

            @Override
            public <T> T computeBitmapResult(BitmapResultFactory<T> bitmapResultFactory, boolean includeUnknown) {
                return bitmapResultFactory.union(() -> bitmapColumnIndices.stream().map(x -> x.computeBitmapResult(bitmapResultFactory, includeUnknown)).iterator());
            }

            @Override
            @Nullable
            public <T> T computeBitmapResult(BitmapResultFactory<T> bitmapResultFactory, int applyRowCount, int totalRowCount, boolean includeUnknown) {
                ArrayList results = Lists.newArrayListWithCapacity((int)bitmapColumnIndices.size());
                for (BitmapColumnIndex index : bitmapColumnIndices) {
                    T r = index.computeBitmapResult(bitmapResultFactory, applyRowCount, totalRowCount, includeUnknown);
                    if (r == null) {
                        return null;
                    }
                    results.add(r);
                }
                return bitmapResultFactory.union(results);
            }
        };
    }

    @Override
    public ValueMatcher makeMatcher(ColumnSelectorFactory factory) {
        ValueMatcher[] matchers = new ValueMatcher[this.filters.size()];
        int i = 0;
        for (Filter filter : this.filters) {
            matchers[i++] = filter.makeMatcher(factory);
        }
        return OrFilter.makeMatcher(matchers);
    }

    @Override
    public VectorValueMatcher makeVectorMatcher(VectorColumnSelectorFactory factory) {
        VectorValueMatcher[] matchers = new VectorValueMatcher[this.filters.size()];
        int i = 0;
        for (Filter filter : this.filters) {
            matchers[i++] = filter.makeVectorMatcher(factory);
        }
        return OrFilter.makeVectorMatcher(matchers);
    }

    @Override
    public boolean canVectorizeMatcher(ColumnInspector inspector) {
        return this.filters.stream().allMatch(filter -> filter.canVectorizeMatcher(inspector));
    }

    @Override
    public LinkedHashSet<Filter> getFilters() {
        return this.filters;
    }

    @Override
    public boolean supportsRequiredColumnRewrite() {
        for (Filter filter : this.filters) {
            if (filter.supportsRequiredColumnRewrite()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Filter rewriteRequiredColumns(Map<String, String> columnRewrites) {
        ArrayList<Filter> newFilters = new ArrayList<Filter>(this.filters.size());
        for (Filter filter : this.filters) {
            newFilters.add(filter.rewriteRequiredColumns(columnRewrites));
        }
        return new OrFilter(newFilters);
    }

    public String toString() {
        return StringUtils.format("(%s)", OR_JOINER.join(this.filters));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrFilter orFilter = (OrFilter)o;
        return Objects.equals(this.getFilters(), orFilter.getFilters());
    }

    public int hashCode() {
        return Objects.hash(this.getFilters());
    }
}

