/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.metadata;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BinaryOperator;
import javax.annotation.Nullable;
import org.apache.druid.common.guava.CombiningSequence;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.JodaUtils;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.java.util.common.guava.MappedSequence;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.query.BySegmentSkippingQueryRunner;
import org.apache.druid.query.CacheStrategy;
import org.apache.druid.query.DefaultGenericQueryMetricsFactory;
import org.apache.druid.query.GenericQueryMetricsFactory;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryMetrics;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.AggregatorFactoryNotMergeableException;
import org.apache.druid.query.aggregation.MetricManipulationFn;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.metadata.SegmentMetadataQueryConfig;
import org.apache.druid.query.metadata.metadata.AggregatorMergeStrategy;
import org.apache.druid.query.metadata.metadata.ColumnAnalysis;
import org.apache.druid.query.metadata.metadata.SegmentAnalysis;
import org.apache.druid.query.metadata.metadata.SegmentMetadataQuery;
import org.apache.druid.segment.AggregateProjectionMetadata;
import org.apache.druid.timeline.LogicalSegment;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.utils.CollectionUtils;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.ReadablePeriod;

public class SegmentMetadataQueryQueryToolChest
extends QueryToolChest<SegmentAnalysis, SegmentMetadataQuery> {
    private static final TypeReference<SegmentAnalysis> TYPE_REFERENCE = new TypeReference<SegmentAnalysis>(){};
    private static final byte SEGMENT_METADATA_CACHE_PREFIX = 4;
    private static final byte SEGMENT_METADATA_QUERY = 22;
    private static final Function<SegmentAnalysis, SegmentAnalysis> MERGE_TRANSFORM_FN = SegmentMetadataQueryQueryToolChest::finalizeAnalysis;
    private final SegmentMetadataQueryConfig config;
    private final GenericQueryMetricsFactory queryMetricsFactory;

    @VisibleForTesting
    public SegmentMetadataQueryQueryToolChest(SegmentMetadataQueryConfig config) {
        this(config, DefaultGenericQueryMetricsFactory.instance());
    }

    @Inject
    public SegmentMetadataQueryQueryToolChest(SegmentMetadataQueryConfig config, GenericQueryMetricsFactory queryMetricsFactory) {
        this.config = config;
        this.queryMetricsFactory = queryMetricsFactory;
    }

    @Override
    public QueryRunner<SegmentAnalysis> mergeResults(QueryRunner<SegmentAnalysis> runner) {
        return new BySegmentSkippingQueryRunner<SegmentAnalysis>(runner){

            @Override
            public Sequence<SegmentAnalysis> doRun(QueryRunner<SegmentAnalysis> baseRunner, QueryPlus<SegmentAnalysis> queryPlus, ResponseContext context) {
                SegmentMetadataQuery updatedQuery = ((SegmentMetadataQuery)queryPlus.getQuery()).withFinalizedAnalysisTypes(SegmentMetadataQueryQueryToolChest.this.config);
                QueryPlus<SegmentAnalysis> updatedQueryPlus = queryPlus.withQuery(updatedQuery);
                return new MappedSequence<SegmentAnalysis, SegmentAnalysis>(CombiningSequence.create(baseRunner.run(updatedQueryPlus, context), this.makeOrdering(updatedQuery), this.createMergeFn(updatedQuery)), arg_0 -> MERGE_TRANSFORM_FN.apply(arg_0));
            }

            private Ordering<SegmentAnalysis> makeOrdering(SegmentMetadataQuery query) {
                return (Ordering)SegmentMetadataQueryQueryToolChest.this.createResultComparator(query);
            }

            private BinaryOperator<SegmentAnalysis> createMergeFn(SegmentMetadataQuery inQ) {
                return SegmentMetadataQueryQueryToolChest.this.createMergeFn(inQ);
            }
        };
    }

    @Override
    public BinaryOperator<SegmentAnalysis> createMergeFn(Query<SegmentAnalysis> query) {
        return (arg1, arg2) -> SegmentMetadataQueryQueryToolChest.mergeAnalyses(query.getDataSource().getTableNames(), arg1, arg2, ((SegmentMetadataQuery)query).getAggregatorMergeStrategy());
    }

    @Override
    public Comparator<SegmentAnalysis> createResultComparator(Query<SegmentAnalysis> query) {
        SegmentMetadataQuery segmentMetadataQuery = (SegmentMetadataQuery)query;
        if (segmentMetadataQuery.isMerge()) {
            return Comparators.alwaysEqual();
        }
        return segmentMetadataQuery.getResultOrdering();
    }

    @Override
    public QueryMetrics<Query<?>> makeMetrics(SegmentMetadataQuery query) {
        return this.queryMetricsFactory.makeMetrics(query);
    }

    @Override
    public Function<SegmentAnalysis, SegmentAnalysis> makePreComputeManipulatorFn(SegmentMetadataQuery query, MetricManipulationFn fn) {
        return Functions.identity();
    }

    @Override
    public TypeReference<SegmentAnalysis> getResultTypeReference() {
        return TYPE_REFERENCE;
    }

    @Override
    public CacheStrategy<SegmentAnalysis, SegmentAnalysis, SegmentMetadataQuery> getCacheStrategy(SegmentMetadataQuery query) {
        return this.getCacheStrategy(query, (ObjectMapper)null);
    }

    @Override
    public CacheStrategy<SegmentAnalysis, SegmentAnalysis, SegmentMetadataQuery> getCacheStrategy(SegmentMetadataQuery query, @Nullable ObjectMapper objectMapper) {
        return new CacheStrategy<SegmentAnalysis, SegmentAnalysis, SegmentMetadataQuery>(){

            @Override
            public boolean isCacheable(SegmentMetadataQuery query, boolean willMergeRunners, boolean bySegment) {
                return true;
            }

            @Override
            public byte[] computeCacheKey(SegmentMetadataQuery query) {
                SegmentMetadataQuery updatedQuery = query.withFinalizedAnalysisTypes(SegmentMetadataQueryQueryToolChest.this.config);
                return new CacheKeyBuilder(4).appendCacheable(updatedQuery.getToInclude()).appendCacheables(updatedQuery.getAnalysisTypes()).build();
            }

            @Override
            public byte[] computeResultLevelCacheKey(SegmentMetadataQuery query) {
                return new CacheKeyBuilder(22).appendByteArray(this.computeCacheKey(query)).appendBoolean(query.isMerge()).build();
            }

            @Override
            public TypeReference<SegmentAnalysis> getCacheObjectClazz() {
                return SegmentMetadataQueryQueryToolChest.this.getResultTypeReference();
            }

            @Override
            public Function<SegmentAnalysis, SegmentAnalysis> prepareForCache(boolean isResultLevelCache) {
                return input -> input;
            }

            @Override
            public Function<SegmentAnalysis, SegmentAnalysis> pullFromCache(boolean isResultLevelCache) {
                return input -> input;
            }
        };
    }

    @Override
    public <T extends LogicalSegment> List<T> filterSegments(SegmentMetadataQuery query, List<T> segments) {
        if (!query.isUsingDefaultInterval()) {
            return segments;
        }
        if (segments.size() <= 1) {
            return segments;
        }
        LogicalSegment max = (LogicalSegment)segments.get(segments.size() - 1);
        DateTime targetEnd = max.getInterval().getEnd();
        Interval targetInterval = new Interval((ReadablePeriod)this.config.getDefaultHistory(), (ReadableInstant)targetEnd);
        return Lists.newArrayList((Iterable)Iterables.filter(segments, input -> input.getInterval().overlaps((ReadableInterval)targetInterval)));
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public static SegmentAnalysis mergeAnalyses(Set<String> dataSources, SegmentAnalysis arg1, SegmentAnalysis arg2, AggregatorMergeStrategy aggregatorMergeStrategy) {
        void var14_21;
        HashMap<String, AggregateProjectionMetadata> projections;
        String mergedId;
        if (arg1 == null) {
            return arg2;
        }
        if (arg2 == null) {
            return arg1;
        }
        if (CollectionUtils.isNullOrEmpty(dataSources)) {
            throw DruidException.defensive("SegementMetadata queries require at least one datasource.", new Object[0]);
        }
        SegmentId mergedSegmentId = null;
        for (String dataSource : dataSources) {
            SegmentId id1 = SegmentId.tryParse(dataSource, arg1.getId());
            SegmentId id2 = SegmentId.tryParse(dataSource, arg2.getId());
            if (id1 == null || id2 == null) continue;
            if (id2.getIntervalEnd().isAfter((ReadableInstant)id1.getIntervalEnd()) || id2.getIntervalEnd().isEqual((ReadableInstant)id1.getIntervalEnd()) && id2.getPartitionNum() > id1.getPartitionNum()) {
                mergedSegmentId = SegmentId.merged(dataSource, id2.getInterval(), id2.getPartitionNum());
                SegmentAnalysis tmp = arg1;
                arg1 = arg2;
                arg2 = tmp;
                break;
            }
            mergedSegmentId = SegmentId.merged(dataSource, id1.getInterval(), id1.getPartitionNum());
            break;
        }
        ArrayList<Object> newIntervals = null;
        if (arg1.getIntervals() != null) {
            newIntervals = new ArrayList<Interval>(arg1.getIntervals());
        }
        if (arg2.getIntervals() != null) {
            if (newIntervals == null) {
                newIntervals = new ArrayList();
            }
            newIntervals.addAll(arg2.getIntervals());
        }
        LinkedHashMap<String, ColumnAnalysis> leftColumns = arg1.getColumns();
        LinkedHashMap<String, ColumnAnalysis> rightColumns = arg2.getColumns();
        LinkedHashMap<String, ColumnAnalysis> columns = new LinkedHashMap<String, ColumnAnalysis>();
        HashSet rightColumnNames = Sets.newHashSet(rightColumns.keySet());
        for (Map.Entry entry : leftColumns.entrySet()) {
            String columnName = (String)entry.getKey();
            columns.put(columnName, ((ColumnAnalysis)entry.getValue()).fold((ColumnAnalysis)rightColumns.get(columnName)));
            rightColumnNames.remove(columnName);
        }
        for (String columnName : rightColumnNames) {
            columns.put(columnName, (ColumnAnalysis)rightColumns.get(columnName));
        }
        HashMap<String, AggregatorFactory> aggregators = new HashMap<String, AggregatorFactory>();
        if (AggregatorMergeStrategy.LENIENT == aggregatorMergeStrategy) {
            for (SegmentAnalysis analysis : ImmutableList.of((Object)arg1, (Object)arg2)) {
                if (analysis.getAggregators() == null) continue;
                for (Map.Entry<String, AggregatorFactory> entry : analysis.getAggregators().entrySet()) {
                    AggregatorFactory merged;
                    String aggregatorName = entry.getKey();
                    AggregatorFactory aggregator = entry.getValue();
                    boolean bl = aggregators.containsKey(aggregatorName);
                    if (!bl) {
                        merged = aggregator;
                    } else {
                        merged = (AggregatorFactory)aggregators.get(aggregatorName);
                        if (merged != null && aggregator != null) {
                            try {
                                merged = merged.getMergingFactory(aggregator);
                            }
                            catch (AggregatorFactoryNotMergeableException e) {
                                merged = null;
                            }
                        } else {
                            merged = null;
                        }
                    }
                    aggregators.put(aggregatorName, merged);
                }
            }
        } else if (AggregatorMergeStrategy.STRICT == aggregatorMergeStrategy) {
            AggregatorFactory[] aggs2;
            UnmodifiableIterator aggs1 = arg1.getAggregators() != null ? arg1.getAggregators().values().toArray(new AggregatorFactory[0]) : null;
            AggregatorFactory[] merged = AggregatorFactory.mergeAggregators(Arrays.asList(aggs1, aggs2 = arg2.getAggregators() != null ? arg2.getAggregators().values().toArray(new AggregatorFactory[0]) : null));
            if (merged != null) {
                for (Object object : merged) {
                    aggregators.put(((AggregatorFactory)object).getName(), (AggregatorFactory)object);
                }
            }
        } else if (AggregatorMergeStrategy.EARLIEST == aggregatorMergeStrategy) {
            for (SegmentAnalysis analysis : ImmutableList.of((Object)arg2, (Object)arg1)) {
                if (analysis.getAggregators() == null) continue;
                for (Map.Entry entry : analysis.getAggregators().entrySet()) {
                    aggregators.putIfAbsent((String)entry.getKey(), (AggregatorFactory)entry.getValue());
                }
            }
        } else if (AggregatorMergeStrategy.LATEST == aggregatorMergeStrategy) {
            for (SegmentAnalysis analysis : ImmutableList.of((Object)arg1, (Object)arg2)) {
                if (analysis.getAggregators() == null) continue;
                for (Map.Entry entry : analysis.getAggregators().entrySet()) {
                    aggregators.putIfAbsent((String)entry.getKey(), (AggregatorFactory)entry.getValue());
                }
            }
        } else {
            throw DruidException.defensive("[%s] merge strategy is not implemented.", new Object[]{aggregatorMergeStrategy});
        }
        TimestampSpec timestampSpec = TimestampSpec.mergeTimestampSpec(Lists.newArrayList((Object[])new TimestampSpec[]{arg1.getTimestampSpec(), arg2.getTimestampSpec()}));
        Granularity queryGranularity = Granularity.mergeGranularities(Lists.newArrayList((Object[])new Granularity[]{arg1.getQueryGranularity(), arg2.getQueryGranularity()}));
        if (arg1.getId() != null && arg2.getId() != null && arg1.getId().equals(arg2.getId())) {
            mergedId = arg1.getId();
        } else {
            String string = mergedId = mergedSegmentId == null ? "merged" : mergedSegmentId.toString();
        }
        if (arg1.isRollup() != null && arg2.isRollup() != null && arg1.isRollup().equals(arg2.isRollup())) {
            Boolean bl = arg1.isRollup();
        } else {
            Object var14_20 = null;
        }
        if (arg1.getProjections() != null && arg2.getProjections() != null) {
            projections = new HashMap<String, AggregateProjectionMetadata>();
            for (String string : Sets.intersection(arg1.getProjections().keySet(), arg2.getProjections().keySet())) {
                AggregateProjectionMetadata spec1 = arg1.getProjections().get(string);
                AggregateProjectionMetadata spec2 = arg2.getProjections().get(string);
                if (!spec1.getSchema().equals(spec2.getSchema())) continue;
                projections.put(string, new AggregateProjectionMetadata(spec1.getSchema(), spec1.getNumRows() + spec2.getNumRows()));
            }
        } else {
            projections = null;
        }
        return new SegmentAnalysis(mergedId, newIntervals, columns, arg1.getSize() + arg2.getSize(), arg1.getNumRows() + arg2.getNumRows(), aggregators.isEmpty() ? null : aggregators, projections == null || projections.isEmpty() ? null : projections, timestampSpec, queryGranularity, (Boolean)var14_21);
    }

    @VisibleForTesting
    public static SegmentAnalysis finalizeAnalysis(SegmentAnalysis analysis) {
        return new SegmentAnalysis(analysis.getId(), analysis.getIntervals() != null ? JodaUtils.condenseIntervals(analysis.getIntervals()) : null, analysis.getColumns(), analysis.getSize(), analysis.getNumRows(), analysis.getAggregators(), analysis.getProjections(), analysis.getTimestampSpec(), analysis.getQueryGranularity(), analysis.isRollup());
    }

    public SegmentMetadataQueryConfig getConfig() {
        return this.config;
    }
}

