/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.post;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Sets;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.column.ColumnType;

public class FinalizingFieldAccessPostAggregator
implements PostAggregator {
    private final String name;
    private final String fieldName;
    @Nullable
    private final ColumnType finalizedType;
    @Nullable
    private final Comparator<Object> comparator;
    @Nullable
    private final Function<Object, Object> finalizer;

    @JsonCreator
    public FinalizingFieldAccessPostAggregator(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName) {
        this(name, fieldName, null, null, null);
    }

    private FinalizingFieldAccessPostAggregator(String name, String fieldName, @Nullable ColumnType finalizedType, @Nullable Comparator<Object> comparator, @Nullable Function<Object, Object> finalizer) {
        this.name = name;
        this.fieldName = fieldName;
        this.finalizedType = finalizedType;
        this.comparator = comparator;
        this.finalizer = finalizer;
    }

    @Override
    public Set<String> getDependentFields() {
        return Sets.newHashSet((Object[])new String[]{this.fieldName});
    }

    @Override
    public Comparator getComparator() {
        if (this.comparator == null) {
            throw new UnsupportedOperationException("Not decorated");
        }
        return this.comparator;
    }

    @Override
    public Object compute(Map<String, Object> combinedAggregators) {
        if (this.finalizer == null) {
            throw new UnsupportedOperationException("Not decorated");
        }
        return this.finalizer.apply(combinedAggregators.get(this.fieldName));
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @Override
    public ColumnType getType(ColumnInspector signature) {
        return this.finalizedType;
    }

    @Override
    public FinalizingFieldAccessPostAggregator decorate(Map<String, AggregatorFactory> aggregators) {
        ColumnType finalizedType;
        Function<Object, Object> theFinalizer;
        Object theComparator;
        if (aggregators != null && aggregators.containsKey(this.fieldName)) {
            theComparator = aggregators.get(this.fieldName).getComparator();
            theFinalizer = aggregators.get(this.fieldName)::finalizeComputation;
            finalizedType = aggregators.get(this.fieldName).getResultType();
        } else {
            theComparator = Comparators.naturalNullsFirst();
            theFinalizer = Function.identity();
            finalizedType = null;
        }
        return new FinalizingFieldAccessPostAggregator(this.name, this.fieldName, finalizedType, (Comparator<Object>)theComparator, theFinalizer);
    }

    @JsonProperty
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public byte[] getCacheKey() {
        return new CacheKeyBuilder(20).appendString(this.fieldName).build();
    }

    public String toString() {
        return "FinalizingFieldAccessPostAggregator{name='" + this.name + "', fieldName='" + this.fieldName + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FinalizingFieldAccessPostAggregator that = (FinalizingFieldAccessPostAggregator)o;
        if (!Objects.equals(this.fieldName, that.fieldName)) {
            return false;
        }
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.fieldName != null ? this.fieldName.hashCode() : 0);
        return result;
    }
}

