/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.write.columnar;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.druid.frame.FrameType;
import org.apache.druid.frame.allocation.AppendableMemory;
import org.apache.druid.frame.allocation.MemoryAllocator;
import org.apache.druid.frame.allocation.MemoryAllocatorFactory;
import org.apache.druid.frame.key.KeyColumn;
import org.apache.druid.frame.write.FrameWriter;
import org.apache.druid.frame.write.FrameWriterFactory;
import org.apache.druid.frame.write.FrameWriterUtils;
import org.apache.druid.frame.write.columnar.ColumnarFrameWriter;
import org.apache.druid.frame.write.columnar.FrameColumnWriter;
import org.apache.druid.frame.write.columnar.FrameColumnWriters;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.utils.CloseableUtils;

public class ColumnarFrameWriterFactory
implements FrameWriterFactory {
    private final MemoryAllocatorFactory allocatorFactory;
    private final RowSignature signature;
    private final List<KeyColumn> keyColumns;

    public ColumnarFrameWriterFactory(MemoryAllocatorFactory allocatorFactory, RowSignature signature, List<KeyColumn> keyColumns) {
        this.allocatorFactory = (MemoryAllocatorFactory)Preconditions.checkNotNull((Object)allocatorFactory, (Object)"allocatorFactory");
        this.signature = signature;
        this.keyColumns = (List)Preconditions.checkNotNull(keyColumns, (Object)"sortColumns");
        if (!keyColumns.isEmpty()) {
            throw new IAE("Columnar frames cannot be sorted", new Object[0]);
        }
        Set<String> disallowedFieldNames = FrameWriterUtils.findDisallowedFieldNames(signature);
        if (!disallowedFieldNames.isEmpty()) {
            throw new IAE("Disallowed field names: %s", disallowedFieldNames);
        }
    }

    @Override
    public FrameWriter newFrameWriter(ColumnSelectorFactory columnSelectorFactory) {
        MemoryAllocator allocator = this.allocatorFactory.newAllocator();
        ArrayList<FrameColumnWriter> columnWriters = new ArrayList<FrameColumnWriter>();
        try {
            for (int i = 0; i < this.signature.size(); ++i) {
                String column = this.signature.getColumnName(i);
                ColumnType columnType = this.signature.getColumnType(i).orElse(null);
                columnWriters.add(FrameColumnWriters.create(columnSelectorFactory, allocator, column, columnType));
            }
        }
        catch (Throwable e) {
            throw CloseableUtils.closeAndWrapInCatch(e, () -> CloseableUtils.closeAll(columnWriters));
        }
        AppendableMemory rowOrderMemory = this.keyColumns.isEmpty() ? null : AppendableMemory.create(allocator);
        return new ColumnarFrameWriter(this.signature, this.keyColumns, rowOrderMemory, columnWriters);
    }

    @Override
    public long allocatorCapacity() {
        return this.allocatorFactory.allocatorCapacity();
    }

    @Override
    public RowSignature signature() {
        return this.signature;
    }

    @Override
    public FrameType frameType() {
        return FrameType.COLUMNAR;
    }
}

