/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.testing.clients;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.common.net.HostAndPort;
import com.google.inject.Inject;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.java.util.http.client.Request;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.java.util.http.client.response.StatusResponseHandler;
import org.apache.druid.java.util.http.client.response.StatusResponseHolder;
import org.apache.druid.query.lookup.LookupsState;
import org.apache.druid.server.coordinator.CoordinatorDynamicConfig;
import org.apache.druid.server.coordinator.rules.Rule;
import org.apache.druid.server.lookup.cache.LookupExtractorFactoryMapContainer;
import org.apache.druid.testing.guice.TestClient;
import org.apache.druid.testing.tools.IntegrationTestingConfig;
import org.apache.druid.timeline.DataSegment;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.joda.time.Interval;

public class CoordinatorResourceTestClient {
    private final ObjectMapper jsonMapper;
    private final HttpClient httpClient;
    private final String coordinator;
    private final StatusResponseHandler responseHandler;

    @Inject
    CoordinatorResourceTestClient(ObjectMapper jsonMapper, @TestClient HttpClient httpClient, IntegrationTestingConfig config) {
        this.jsonMapper = jsonMapper;
        this.httpClient = httpClient;
        this.coordinator = config.getCoordinatorUrl();
        this.responseHandler = StatusResponseHandler.getInstance();
    }

    private String getCoordinatorURL() {
        return StringUtils.format((String)"%s/druid/coordinator/v1/", (Object[])new Object[]{this.coordinator});
    }

    private String getSegmentsMetadataURL(String dataSource) {
        return StringUtils.format((String)"%smetadata/datasources/%s/segments", (Object[])new Object[]{this.getCoordinatorURL(), StringUtils.urlEncode((String)dataSource)});
    }

    private String getFullSegmentsMetadataURL(String dataSource) {
        return StringUtils.format((String)"%smetadata/datasources/%s/segments?full", (Object[])new Object[]{this.getCoordinatorURL(), StringUtils.urlEncode((String)dataSource)});
    }

    private String getIntervalsURL(String dataSource) {
        return StringUtils.format((String)"%sdatasources/%s/intervals", (Object[])new Object[]{this.getCoordinatorURL(), StringUtils.urlEncode((String)dataSource)});
    }

    private String getFullSegmentsURL(String dataSource) {
        return StringUtils.format((String)"%sdatasources/%s/segments?full", (Object[])new Object[]{this.getCoordinatorURL(), StringUtils.urlEncode((String)dataSource)});
    }

    private String getLoadStatusURL(String dataSource) {
        return StringUtils.format((String)"%sdatasources/%s/loadstatus?forceMetadataRefresh=true&interval=1970-01-01/2999-01-01", (Object[])new Object[]{this.getCoordinatorURL(), StringUtils.urlEncode((String)dataSource)});
    }

    public List<String> getSegments(String dataSource) {
        List segments;
        try {
            StatusResponseHolder response = this.makeRequest(HttpMethod.GET, this.getSegmentsMetadataURL(dataSource));
            segments = (List)this.jsonMapper.readValue(response.getContent(), (TypeReference)new TypeReference<List<String>>(){});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return segments;
    }

    public List<DataSegment> getFullSegmentsMetadata(String dataSource) {
        List segments;
        try {
            StatusResponseHolder response = this.makeRequest(HttpMethod.GET, this.getFullSegmentsMetadataURL(dataSource));
            segments = (List)this.jsonMapper.readValue(response.getContent(), (TypeReference)new TypeReference<List<DataSegment>>(){});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return segments;
    }

    public List<String> getSegmentIntervals(String dataSource) {
        List segments;
        try {
            StatusResponseHolder response = this.makeRequest(HttpMethod.GET, this.getIntervalsURL(dataSource));
            segments = (List)this.jsonMapper.readValue(response.getContent(), (TypeReference)new TypeReference<List<String>>(){});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return segments;
    }

    public List<DataSegment> getAvailableSegments(String dataSource) {
        try {
            StatusResponseHolder response = this.makeRequest(HttpMethod.GET, this.getFullSegmentsURL(dataSource));
            return (List)this.jsonMapper.readValue(response.getContent(), (TypeReference)new TypeReference<List<DataSegment>>(){});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Map<String, Integer> getLoadStatus(String dataSource) {
        Map status;
        String url = this.getLoadStatusURL(dataSource);
        try {
            StatusResponseHolder response = (StatusResponseHolder)this.httpClient.go(new Request(HttpMethod.GET, new URL(url)), (HttpResponseHandler)this.responseHandler).get();
            if (response.getStatus().getCode() == HttpResponseStatus.NO_CONTENT.getCode()) {
                return null;
            }
            if (response.getStatus().getCode() != HttpResponseStatus.OK.getCode()) {
                throw new ISE("Error while making request to url [%s] status [%s] content [%s]", new Object[]{url, response.getStatus(), response.getContent()});
            }
            status = (Map)this.jsonMapper.readValue(response.getContent(), (TypeReference)new TypeReference<Map<String, Integer>>(){});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return status;
    }

    public boolean areSegmentsLoaded(String dataSource) {
        Map<String, Integer> status = this.getLoadStatus(dataSource);
        return status != null && status.containsKey(dataSource) && (double)status.get(dataSource).intValue() == 100.0;
    }

    public void unloadSegmentsForDataSource(String dataSource) {
        try {
            this.makeRequest(HttpMethod.DELETE, StringUtils.format((String)"%sdatasources/%s", (Object[])new Object[]{this.getCoordinatorURL(), StringUtils.urlEncode((String)dataSource)}));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteSegmentsDataSource(String dataSource, Interval interval) {
        try {
            this.makeRequest(HttpMethod.DELETE, StringUtils.format((String)"%sdatasources/%s/intervals/%s", (Object[])new Object[]{this.getCoordinatorURL(), StringUtils.urlEncode((String)dataSource), interval.toString().replace('/', '_')}));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, Object> initializeLookups(String filePath) throws Exception {
        String url = StringUtils.format((String)"%slookups/config", (Object[])new Object[]{this.getCoordinatorURL()});
        StatusResponseHolder response = (StatusResponseHolder)this.httpClient.go(new Request(HttpMethod.POST, new URL(url)).setContent("application/json", this.jsonMapper.writeValueAsBytes((Object)ImmutableMap.of())), (HttpResponseHandler)this.responseHandler).get();
        if (!response.getStatus().equals((Object)HttpResponseStatus.ACCEPTED)) {
            throw new ISE("Error while querying [%s] status [%s] content [%s]", new Object[]{url, response.getStatus(), response.getContent()});
        }
        StatusResponseHolder response2 = (StatusResponseHolder)this.httpClient.go(new Request(HttpMethod.POST, new URL(url)).setContent("application/json", this.jsonMapper.writeValueAsBytes(this.jsonMapper.readValue(CoordinatorResourceTestClient.class.getResourceAsStream(filePath), (TypeReference)new TypeReference<Map<Object, Object>>(){}))), (HttpResponseHandler)this.responseHandler).get();
        if (!response2.getStatus().equals((Object)HttpResponseStatus.ACCEPTED)) {
            throw new ISE("Error while querying [%s] status [%s] content [%s]", new Object[]{url, response2.getStatus(), response2.getContent()});
        }
        Map results2 = (Map)this.jsonMapper.readValue(response.getContent(), (TypeReference)new TypeReference<Map<String, Object>>(){});
        return results2;
    }

    @Nullable
    private Map<String, Map<HostAndPort, LookupsState<LookupExtractorFactoryMapContainer>>> getLookupLoadStatus() {
        Map status;
        String url = StringUtils.format((String)"%slookups/nodeStatus", (Object[])new Object[]{this.getCoordinatorURL()});
        try {
            StatusResponseHolder response = (StatusResponseHolder)this.httpClient.go(new Request(HttpMethod.GET, new URL(url)), (HttpResponseHandler)this.responseHandler).get();
            if (response.getStatus().getCode() == HttpResponseStatus.NOT_FOUND.getCode()) {
                return null;
            }
            if (response.getStatus().getCode() != HttpResponseStatus.OK.getCode()) {
                throw new ISE("Error while making request to url [%s] status [%s] content [%s]", new Object[]{url, response.getStatus(), response.getContent()});
            }
            status = (Map)this.jsonMapper.readValue(response.getContent(), (TypeReference)new TypeReference<Map<String, Map<HostAndPort, LookupsState<LookupExtractorFactoryMapContainer>>>>(){});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return status;
    }

    public boolean areLookupsLoaded(String lookup) {
        Map<String, Map<HostAndPort, LookupsState<LookupExtractorFactoryMapContainer>>> status = this.getLookupLoadStatus();
        if (status == null) {
            return false;
        }
        Map<HostAndPort, LookupsState<LookupExtractorFactoryMapContainer>> defaultTier = status.get("__default");
        boolean isLoaded = true;
        for (Map.Entry<HostAndPort, LookupsState<LookupExtractorFactoryMapContainer>> host : defaultTier.entrySet()) {
            isLoaded &= host.getValue().getCurrent().containsKey(lookup);
        }
        return isLoaded;
    }

    public void postDynamicConfig(CoordinatorDynamicConfig coordinatorDynamicConfig) throws Exception {
        String url = StringUtils.format((String)"%sconfig", (Object[])new Object[]{this.getCoordinatorURL()});
        StatusResponseHolder response = (StatusResponseHolder)this.httpClient.go(new Request(HttpMethod.POST, new URL(url)).setContent("application/json", this.jsonMapper.writeValueAsBytes((Object)coordinatorDynamicConfig)), (HttpResponseHandler)this.responseHandler).get();
        if (!response.getStatus().equals((Object)HttpResponseStatus.OK)) {
            throw new ISE("Error while setting dynamic config [%s] status [%s] content [%s]", new Object[]{url, response.getStatus(), response.getContent()});
        }
    }

    public void postLoadRules(String datasourceName, List<Rule> rules) throws Exception {
        String url = StringUtils.format((String)"%srules/%s", (Object[])new Object[]{this.getCoordinatorURL(), datasourceName});
        StatusResponseHolder response = (StatusResponseHolder)this.httpClient.go(new Request(HttpMethod.POST, new URL(url)).setContent("application/json", this.jsonMapper.writeValueAsBytes(rules)), (HttpResponseHandler)this.responseHandler).get();
        if (!response.getStatus().equals((Object)HttpResponseStatus.OK)) {
            throw new ISE("Error while setting dynamic config [%s] status [%s] content [%s]", new Object[]{url, response.getStatus(), response.getContent()});
        }
    }

    public CoordinatorDynamicConfig getDynamicConfig() {
        CoordinatorDynamicConfig config;
        String url = StringUtils.format((String)"%sconfig", (Object[])new Object[]{this.getCoordinatorURL()});
        try {
            StatusResponseHolder response = this.makeRequest(HttpMethod.GET, url);
            config = (CoordinatorDynamicConfig)this.jsonMapper.readValue(response.getContent(), CoordinatorDynamicConfig.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return config;
    }

    private StatusResponseHolder makeRequest(HttpMethod method, String url) {
        try {
            StatusResponseHolder response = (StatusResponseHolder)this.httpClient.go(new Request(method, new URL(url)), (HttpResponseHandler)this.responseHandler).get();
            if (!response.getStatus().equals((Object)HttpResponseStatus.OK)) {
                throw new ISE("Error while making request to url [%s] status [%s] content [%s]", new Object[]{url, response.getStatus(), response.getContent()});
            }
            return response;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

