/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.testing.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.DockerCmdExecFactory;
import com.github.dockerjava.api.command.ExecCreateCmdResponse;
import com.github.dockerjava.api.model.Container;
import com.github.dockerjava.core.DockerClientBuilder;
import com.github.dockerjava.core.command.ExecStartResultCallback;
import com.github.dockerjava.netty.NettyDockerCmdExecFactory;
import com.google.inject.Inject;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.java.util.http.client.Request;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.java.util.http.client.response.StatusResponseHandler;
import org.apache.druid.java.util.http.client.response.StatusResponseHolder;
import org.apache.druid.server.coordinator.CoordinatorDynamicConfig;
import org.apache.druid.testing.guice.TestClient;
import org.apache.druid.testing.tools.ITRetryUtil;
import org.apache.druid.testing.tools.IntegrationTestingConfig;
import org.jboss.netty.channel.ChannelException;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;

public class DruidClusterAdminClient {
    public static final String COORDINATOR_DOCKER_CONTAINER_NAME = "/druid-coordinator";
    public static final String COORDINATOR_TWO_DOCKER_CONTAINER_NAME = "/druid-coordinator-two";
    public static final String HISTORICAL_DOCKER_CONTAINER_NAME = "/druid-historical";
    public static final String OVERLORD_DOCKER_CONTAINER_NAME = "/druid-overlord";
    public static final String OVERLORD_TWO_DOCKER_CONTAINER_NAME = "/druid-overlord-two";
    public static final String BROKER_DOCKER_CONTAINER_NAME = "/druid-broker";
    public static final String ROUTER_DOCKER_CONTAINER_NAME = "/druid-router";
    public static final String MIDDLEMANAGER_DOCKER_CONTAINER_NAME = "/druid-middlemanager";
    private static final Logger LOG = new Logger(DruidClusterAdminClient.class);
    private final ObjectMapper jsonMapper;
    private final HttpClient httpClient;
    private IntegrationTestingConfig config;

    @Inject
    DruidClusterAdminClient(ObjectMapper jsonMapper, @TestClient HttpClient httpClient, IntegrationTestingConfig config) {
        this.jsonMapper = jsonMapper;
        this.httpClient = httpClient;
        this.config = config;
    }

    public void restartCoordinatorContainer() {
        this.restartDockerContainer(COORDINATOR_DOCKER_CONTAINER_NAME);
    }

    public void restartCoordinatorTwoContainer() {
        this.restartDockerContainer(COORDINATOR_TWO_DOCKER_CONTAINER_NAME);
    }

    public void restartHistoricalContainer() {
        this.restartDockerContainer(HISTORICAL_DOCKER_CONTAINER_NAME);
    }

    public void restartOverlordContainer() {
        this.restartDockerContainer(OVERLORD_DOCKER_CONTAINER_NAME);
    }

    public void restartOverlordTwoContainer() {
        this.restartDockerContainer(OVERLORD_TWO_DOCKER_CONTAINER_NAME);
    }

    public void restartBrokerContainer() {
        this.restartDockerContainer(BROKER_DOCKER_CONTAINER_NAME);
    }

    public void restartRouterContainer() {
        this.restartDockerContainer(ROUTER_DOCKER_CONTAINER_NAME);
    }

    public void restartMiddleManagerContainer() {
        this.restartDockerContainer(MIDDLEMANAGER_DOCKER_CONTAINER_NAME);
    }

    public void waitUntilCoordinatorReady() {
        this.waitUntilInstanceReady(this.config.getCoordinatorUrl());
        this.postDynamicConfig(CoordinatorDynamicConfig.builder().withMarkSegmentAsUnusedDelayMillis(1L).build());
    }

    public void waitUntilCoordinatorTwoReady() {
        this.waitUntilInstanceReady(this.config.getCoordinatorTwoUrl());
        this.postDynamicConfig(CoordinatorDynamicConfig.builder().withMarkSegmentAsUnusedDelayMillis(1L).build());
    }

    public void waitUntilOverlordTwoReady() {
        this.waitUntilInstanceReady(this.config.getOverlordTwoUrl());
    }

    public void waitUntilHistoricalReady() {
        this.waitUntilInstanceReady(this.config.getHistoricalUrl());
    }

    public void waitUntilIndexerReady() {
        this.waitUntilInstanceReady(this.config.getOverlordUrl());
    }

    public void waitUntilBrokerReady() {
        this.waitUntilInstanceReady(this.config.getBrokerUrl());
    }

    public void waitUntilRouterReady() {
        this.waitUntilInstanceReady(this.config.getRouterUrl());
    }

    public Pair<String, String> runCommandInCoordinatorContainer(String ... cmd) throws Exception {
        return this.runCommandInDockerContainer(COORDINATOR_DOCKER_CONTAINER_NAME, cmd);
    }

    public Pair<String, String> runCommandInCoordinatorTwoContainer(String ... cmd) throws Exception {
        return this.runCommandInDockerContainer(COORDINATOR_TWO_DOCKER_CONTAINER_NAME, cmd);
    }

    public Pair<String, String> runCommandInHistoricalContainer(String ... cmd) throws Exception {
        return this.runCommandInDockerContainer(HISTORICAL_DOCKER_CONTAINER_NAME, cmd);
    }

    public Pair<String, String> runCommandInOverlordContainer(String ... cmd) throws Exception {
        return this.runCommandInDockerContainer(OVERLORD_DOCKER_CONTAINER_NAME, cmd);
    }

    public Pair<String, String> runCommandInOverlordTwoContainer(String ... cmd) throws Exception {
        return this.runCommandInDockerContainer(OVERLORD_TWO_DOCKER_CONTAINER_NAME, cmd);
    }

    public Pair<String, String> runCommandInBrokerContainer(String ... cmd) throws Exception {
        return this.runCommandInDockerContainer(BROKER_DOCKER_CONTAINER_NAME, cmd);
    }

    public Pair<String, String> runCommandInRouterContainer(String ... cmd) throws Exception {
        return this.runCommandInDockerContainer(ROUTER_DOCKER_CONTAINER_NAME, cmd);
    }

    public Pair<String, String> runCommandInMiddleManagerContainer(String ... cmd) throws Exception {
        return this.runCommandInDockerContainer(MIDDLEMANAGER_DOCKER_CONTAINER_NAME, cmd);
    }

    public Pair<String, String> runCommandInDockerContainer(String serviceName, String ... cmd) throws Exception {
        DockerClient dockerClient = DruidClusterAdminClient.newClient();
        ByteArrayOutputStream stdout = new ByteArrayOutputStream();
        ByteArrayOutputStream stderr = new ByteArrayOutputStream();
        ExecCreateCmdResponse execCreateCmdResponse = (ExecCreateCmdResponse)dockerClient.execCreateCmd(this.findDockerContainer(dockerClient, serviceName)).withAttachStderr(Boolean.valueOf(true)).withAttachStdout(Boolean.valueOf(true)).withCmd(cmd).exec();
        ((ExecStartResultCallback)dockerClient.execStartCmd(execCreateCmdResponse.getId()).exec((ResultCallback)new ExecStartResultCallback((OutputStream)stdout, (OutputStream)stderr))).awaitCompletion();
        return new Pair((Object)stdout.toString(StandardCharsets.UTF_8), (Object)stderr.toString(StandardCharsets.UTF_8));
    }

    public void restartDockerContainer(String serviceName) {
        DockerClient dockerClient = DruidClusterAdminClient.newClient();
        dockerClient.restartContainerCmd(this.findDockerContainer(dockerClient, serviceName)).exec();
    }

    public void killAndRestartDockerContainer(String serviceName) {
        DockerClient dockerClient = DruidClusterAdminClient.newClient();
        String containerId = this.findDockerContainer(dockerClient, serviceName);
        dockerClient.killContainerCmd(containerId).withSignal("SIGKILL").exec();
        dockerClient.startContainerCmd(containerId).exec();
    }

    private static DockerClient newClient() {
        return DockerClientBuilder.getInstance().withDockerCmdExecFactory((DockerCmdExecFactory)new NettyDockerCmdExecFactory().withConnectTimeout(Integer.valueOf(10000))).build();
    }

    private String findDockerContainer(DockerClient dockerClient, String serviceName) {
        List containers = (List)dockerClient.listContainersCmd().exec();
        Optional<String> containerName = containers.stream().filter(container -> Arrays.asList(container.getNames()).contains(serviceName)).findFirst().map(Container::getId);
        if (!containerName.isPresent()) {
            LOG.error("Cannot find docker container for " + serviceName, new Object[0]);
            throw new ISE("Cannot find docker container for " + serviceName, new Object[0]);
        }
        return containerName.get();
    }

    private void waitUntilInstanceReady(String host) {
        ITRetryUtil.retryUntilEquals(() -> {
            try {
                StatusResponseHolder response = (StatusResponseHolder)this.httpClient.go(new Request(HttpMethod.GET, new URL(StringUtils.format((String)"%s/status/health", (Object[])new Object[]{host}))), (HttpResponseHandler)StatusResponseHandler.getInstance()).get();
                LOG.info("%s %s", new Object[]{response.getStatus(), response.getContent()});
                return response.getStatus().equals((Object)HttpResponseStatus.OK) ? "READY" : "";
            }
            catch (Throwable e) {
                if (e.getCause() instanceof ChannelException) {
                    Throwable channelException = e.getCause();
                    if (channelException.getCause() instanceof ClosedChannelException) {
                        LOG.error("Channel Closed", new Object[0]);
                    } else if ("Channel disconnected".equals(channelException.getMessage())) {
                        LOG.error("Channel disconnected", new Object[0]);
                    } else {
                        LOG.error(e, "Error while waiting for [%s] to be ready", new Object[]{host});
                    }
                } else {
                    LOG.error(e, "Error while waiting for [%s] to be ready", new Object[]{host});
                }
                return "";
            }
        }, (Object)"READY", (String)StringUtils.format((String)"Instance[%s]", (Object[])new Object[]{host}));
    }

    private void postDynamicConfig(CoordinatorDynamicConfig coordinatorDynamicConfig) {
        ITRetryUtil.retryUntilTrue(() -> {
            try {
                String url = StringUtils.format((String)"%s/druid/coordinator/v1/config", (Object[])new Object[]{this.config.getCoordinatorUrl()});
                StatusResponseHolder response = (StatusResponseHolder)this.httpClient.go(new Request(HttpMethod.POST, new URL(url)).setContent("application/json", this.jsonMapper.writeValueAsBytes((Object)coordinatorDynamicConfig)), (HttpResponseHandler)StatusResponseHandler.getInstance()).get();
                LOG.info("%s %s", new Object[]{response.getStatus(), response.getContent()});
                return response.getStatus().equals((Object)HttpResponseStatus.OK) || response.getStatus().equals((Object)HttpResponseStatus.TEMPORARY_REDIRECT);
            }
            catch (Throwable e) {
                LOG.error(e, "Error while posting dynamic config", new Object[0]);
                return false;
            }
        }, (String)"Posting dynamic config after startup");
    }
}

