/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.testing.utils;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.druid.testing.tools.IntegrationTestingConfig;
import org.apache.druid.testing.tools.KafkaUtil;
import org.apache.druid.testing.utils.StreamAdminClient;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.CreatePartitionsResult;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.DeleteTopicsResult;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;

public class KafkaAdminClient
implements StreamAdminClient {
    private AdminClient adminClient;

    public KafkaAdminClient(IntegrationTestingConfig config) {
        Properties properties = new Properties();
        properties.setProperty("bootstrap.servers", config.getKafkaHost());
        KafkaUtil.addPropertiesFromTestConfig((IntegrationTestingConfig)config, (Properties)properties);
        this.adminClient = AdminClient.create((Properties)properties);
    }

    @Override
    public void createStream(String streamName, int partitionCount, Map<String, String> tags) throws Exception {
        boolean replicationFactor = true;
        NewTopic newTopic = new NewTopic(streamName, partitionCount, 1);
        CreateTopicsResult createTopicsResult = this.adminClient.createTopics(Collections.singleton(newTopic));
        ((KafkaFuture)createTopicsResult.values().get(streamName)).get();
    }

    @Override
    public void deleteStream(String streamName) throws Exception {
        DeleteTopicsResult deleteTopicsResult = this.adminClient.deleteTopics((Collection)ImmutableList.of((Object)streamName));
        ((KafkaFuture)deleteTopicsResult.values().get(streamName)).get();
    }

    @Override
    public void updatePartitionCount(String streamName, int newPartitionCount, boolean blocksUntilStarted) throws Exception {
        HashMap<String, NewPartitions> counts = new HashMap<String, NewPartitions>();
        counts.put(streamName, NewPartitions.increaseTo((int)newPartitionCount));
        CreatePartitionsResult createPartitionsResult = this.adminClient.createPartitions(counts);
        if (blocksUntilStarted) {
            ((KafkaFuture)createPartitionsResult.values().get(streamName)).get();
        }
    }

    @Override
    public boolean isStreamActive(String streamName) {
        return true;
    }

    @Override
    public int getStreamPartitionCount(String streamName) throws Exception {
        DescribeTopicsResult result = this.adminClient.describeTopics((Collection)ImmutableList.of((Object)streamName));
        TopicDescription topicDescription = (TopicDescription)((KafkaFuture)result.values().get(streamName)).get();
        return topicDescription.partitions().size();
    }

    @Override
    public boolean verfiyPartitionCountUpdated(String streamName, int oldPartitionCount, int newPartitionCount) throws Exception {
        return this.getStreamPartitionCount(streamName) == newPartitionCount;
    }
}

